/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.track;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;

public class VolumeMode
extends AbstractTrackMode {
    public VolumeMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.model.getCurrentTrackBank().getTrack(index).changeVolume(value);
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack t = tb.getTrack(index);
        if (!t.doesExist()) {
            return;
        }
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                t.resetVolume();
            } else {
                ((PushControlSurface)this.surface).getDisplay().notify("Volume: " + t.getVolumeStr(8));
            }
        }
        t.touchVolume(isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        IChannelBank tb = this.model.getCurrentTrackBank();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(i);
            d.setCell(0, i, t.doesExist() ? "Volume" : "").setCell(1, i, t.getVolumeStr(8));
            if (t.doesExist()) {
                d.setCell(2, i, config.isEnableVUMeters() ? t.getVu() : t.getVolume(), Format.FORMAT_VALUE);
                continue;
            }
            d.clearCell(2, i);
        }
        d.done(0).done(1).done(2);
        this.drawRow4();
    }

    @Override
    public void updateDisplay2() {
        this.updateChannelDisplay(1, true, false);
    }
}

