/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.track;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.Pair;

public class TrackMode
extends AbstractTrackMode {
    public TrackMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        ITrack selectedTrack = this.model.getSelectedTrack();
        if (selectedTrack == null) {
            return;
        }
        switch (index) {
            case 0: {
                selectedTrack.changeVolume(value);
                return;
            }
            case 1: {
                selectedTrack.changePan(value);
                return;
            }
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (this.isPush2) {
            switch (index) {
                case 2: {
                    this.changeCrossfader(value, selectedTrack);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    int sendOffset = config.isSendsAreToggled() ? 0 : 4;
                    selectedTrack.getSend(index - sendOffset).changeValue(value);
                }
            }
            return;
        }
        switch (index) {
            case 2: {
                if (config.isDisplayCrossfader()) {
                    this.changeCrossfader(value, selectedTrack);
                    break;
                }
                selectedTrack.getSend(0).changeValue(value);
                break;
            }
            default: {
                selectedTrack.getSend(index - (config.isDisplayCrossfader() ? 3 : 2)).changeValue(value);
            }
        }
    }

    private void changeCrossfader(int value, ITrack selectedTrack) {
        if (this.increaseKnobMovement()) {
            selectedTrack.changeCrossfadeModeAsNumber(value);
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        ITrack selectedTrack = this.model.getSelectedTrack();
        if (selectedTrack == null) {
            return;
        }
        this.isKnobTouched[index] = isTouched;
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (this.isPush2) {
            if (isTouched) {
                if (((PushControlSurface)this.surface).isDeletePressed()) {
                    ((PushControlSurface)this.surface).setButtonConsumed(118);
                    switch (index) {
                        case 0: {
                            selectedTrack.resetVolume();
                            break;
                        }
                        case 1: {
                            selectedTrack.resetPan();
                            break;
                        }
                        case 2: {
                            selectedTrack.setCrossfadeMode("AB");
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            selectedTrack.getSend(index - 4).resetValue();
                        }
                    }
                    return;
                }
                PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
                switch (index) {
                    case 0: {
                        display.notify("Volume: " + selectedTrack.getVolumeStr(8));
                        break;
                    }
                    case 1: {
                        display.notify("Pan: " + selectedTrack.getPanStr(8));
                        break;
                    }
                    case 2: {
                        display.notify("Crossfader: " + selectedTrack.getCrossfadeMode());
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        String name;
                        int sendIndex = index - 4;
                        IChannelBank fxTrackBank = this.model.getEffectTrackBank();
                        String string = name = fxTrackBank == null ? selectedTrack.getSend(sendIndex).getName() : fxTrackBank.getTrack(sendIndex).getName();
                        if (name.length() <= 0) break;
                        display.notify("Send " + name + ": " + selectedTrack.getSend(sendIndex).getDisplayedValue(8));
                    }
                }
            }
            switch (index) {
                case 0: {
                    selectedTrack.touchVolume(isTouched);
                    break;
                }
                case 1: {
                    selectedTrack.touchPan(isTouched);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    int sendIndex = index - 4;
                    selectedTrack.getSend(sendIndex).touchValue(isTouched);
                }
            }
            this.checkStopAutomationOnKnobRelease(isTouched);
            return;
        }
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(118);
                switch (index) {
                    case 0: {
                        selectedTrack.resetVolume();
                        break;
                    }
                    case 1: {
                        selectedTrack.resetPan();
                        break;
                    }
                    case 2: {
                        if (config.isDisplayCrossfader()) {
                            selectedTrack.setCrossfadeMode("AB");
                            break;
                        }
                        selectedTrack.getSend(0).resetValue();
                        break;
                    }
                    default: {
                        selectedTrack.getSend(index - (config.isDisplayCrossfader() ? 3 : 2)).resetValue();
                    }
                }
                return;
            }
            PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
            switch (index) {
                case 0: {
                    display.notify("Volume: " + selectedTrack.getVolumeStr(8));
                    break;
                }
                case 1: {
                    display.notify("Pan: " + selectedTrack.getPanStr(8));
                    break;
                }
                case 2: {
                    String name;
                    if (config.isDisplayCrossfader()) {
                        display.notify("Crossfader: " + selectedTrack.getCrossfadeMode());
                        break;
                    }
                    boolean sendIndex = false;
                    IChannelBank fxTrackBank = this.model.getEffectTrackBank();
                    String string = name = fxTrackBank == null ? selectedTrack.getSend(0).getName() : fxTrackBank.getTrack(0).getName();
                    if (name.length() <= 0) break;
                    display.notify("Send " + name + ": " + selectedTrack.getSend(0).getDisplayedValue(8));
                    break;
                }
                default: {
                    String name;
                    int sendIndex = index - (config.isDisplayCrossfader() ? 3 : 2);
                    IChannelBank fxTrackBank = this.model.getEffectTrackBank();
                    String string = name = fxTrackBank == null ? selectedTrack.getSend(sendIndex).getName() : fxTrackBank.getTrack(sendIndex).getName();
                    if (name.length() <= 0) break;
                    display.notify("Send " + name + ": " + selectedTrack.getSend(sendIndex).getDisplayedValue(8));
                }
            }
        }
        switch (index) {
            case 0: {
                selectedTrack.touchVolume(isTouched);
                break;
            }
            case 1: {
                selectedTrack.touchPan(isTouched);
                break;
            }
            case 2: {
                if (config.isDisplayCrossfader()) break;
                selectedTrack.getSend(0).touchValue(isTouched);
                break;
            }
            default: {
                int sendIndex = index - (config.isDisplayCrossfader() ? 3 : 2);
                selectedTrack.getSend(sendIndex).touchValue(isTouched);
            }
        }
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay().clear();
        ITrack t = this.model.getSelectedTrack();
        if (t == null) {
            d.setRow(1, "                     Please selecta track...                        ").done(0).done(2);
        } else {
            PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
            d.setCell(0, 0, "Volume").setCell(1, 0, t.getVolumeStr(8)).setCell(2, 0, config.isEnableVUMeters() ? t.getVu() : t.getVolume(), Format.FORMAT_VALUE);
            d.setCell(0, 1, "Pan").setCell(1, 1, t.getPanStr(8)).setCell(2, 1, t.getPan(), Format.FORMAT_PAN);
            int sendStart = 2;
            int sendCount = 6;
            if (config.isDisplayCrossfader()) {
                sendStart = 3;
                sendCount = 5;
                String crossfadeMode = t.getCrossfadeMode();
                int upperBound = this.model.getValueChanger().getUpperBound();
                d.setCell(0, 2, "Crossfdr").setCell(1, 2, "A".equals(crossfadeMode) ? "A" : ("B".equals(crossfadeMode) ? "       B" : "   <> "));
                d.setCell(2, 2, "A".equals(crossfadeMode) ? 0 : ("B".equals(crossfadeMode) ? upperBound : upperBound / 2), Format.FORMAT_PAN);
            }
            boolean isEffectTrackBankActive = this.model.isEffectTrackBankActive();
            for (int i = 0; i < sendCount; ++i) {
                ISend send;
                int pos = sendStart + i;
                if (isEffectTrackBankActive || !(send = t.getSend(i)).doesExist()) continue;
                d.setCell(0, pos, send.getName()).setCell(1, pos, send.getDisplayedValue(8)).setCell(2, pos, send.getValue(), Format.FORMAT_VALUE);
            }
            d.done(0).done(1).done(2);
        }
        this.drawRow4();
    }

    @Override
    public void updateDisplay2() {
        int sendsIndex;
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack selectedTrack = tb.getSelectedTrack();
        int selectedIndex = selectedTrack == null ? -1 : selectedTrack.getIndex();
        int n = sendsIndex = selectedTrack == null || this.model.isEffectTrackBankActive() ? -1 : selectedTrack.getIndex() + 1;
        if (sendsIndex == 8) {
            sendsIndex = 6;
        }
        this.updateMenuItems(0);
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        boolean displayCrossfader = config.isDisplayCrossfader();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(i);
            Pair pair = (Pair)this.menu.get(i);
            String topMenu = (String)pair.getKey();
            boolean topMenuSelected = (Boolean)pair.getValue();
            String bottomMenu = t.doesExist() ? t.getName() : "";
            double[] bottomMenuColor = t.getColor();
            boolean isBottomMenuOn = t.isSelected();
            IValueChanger valueChanger = this.model.getValueChanger();
            if (t.isSelected()) {
                int crossfadeMode = displayCrossfader ? t.getCrossfadeModeAsNumber() : -1;
                message.addChannelElement(topMenu, topMenuSelected, bottomMenu, t.getType(), bottomMenuColor, isBottomMenuOn, valueChanger.toDisplayValue(t.getVolume()), valueChanger.toDisplayValue(t.getModulatedVolume()), this.isKnobTouched[0] ? t.getVolumeStr(8) : "", valueChanger.toDisplayValue(t.getPan()), valueChanger.toDisplayValue(t.getModulatedPan()), this.isKnobTouched[1] ? t.getPanStr(8) : "", valueChanger.toDisplayValue(config.isEnableVUMeters() ? t.getVu() : 0), t.isMute(), t.isSolo(), t.isRecArm(), crossfadeMode);
                continue;
            }
            if (sendsIndex == i) {
                IChannelBank fxTrackBank = this.model.getEffectTrackBank();
                ITrack selTrack = tb.getTrack(selectedIndex);
                String[] sendName = new String[4];
                String[] valueStr = new String[4];
                int[] value = new int[4];
                int[] modulatedValue = new int[4];
                boolean[] selected = new boolean[4];
                for (int j = 0; j < 4; ++j) {
                    ISend send;
                    int sendOffset = config.isSendsAreToggled() ? 4 : 0;
                    int sendPos = sendOffset + j;
                    selected[j] = true;
                    sendName[j] = "";
                    valueStr[j] = "";
                    value[j] = 0;
                    if (selTrack == null || (send = selTrack.getSend(sendPos)) == null) continue;
                    sendName[j] = fxTrackBank == null ? send.getName() : fxTrackBank.getTrack(sendPos).getName();
                    valueStr[j] = send.doesExist() && this.isKnobTouched[4 + j] ? send.getDisplayedValue(8) : "";
                    value[j] = valueChanger.toDisplayValue(send.doesExist() ? send.getValue() : 0);
                    modulatedValue[j] = valueChanger.toDisplayValue(send.doesExist() ? send.getModulatedValue() : 0);
                }
                message.addSendsElement(topMenu, topMenuSelected, bottomMenu, t.getType(), bottomMenuColor, isBottomMenuOn, sendName, valueStr, value, modulatedValue, selected, true);
                continue;
            }
            message.addChannelSelectorElement(topMenu, topMenuSelected, bottomMenu, t.getType(), bottomMenuColor, isBottomMenuOn);
        }
        display.send(message);
    }
}

