/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.track;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.view.ColorView;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ViewManager;

public class TrackDetailsMode
extends BaseMode {
    public TrackDetailsMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (this.model.getMasterTrack().isSelected()) {
            this.onFirstRowMasterTrack(index);
        } else {
            this.onFirstRowTrack(index);
        }
    }

    private void onFirstRowMasterTrack(int index) {
        switch (index) {
            case 0: {
                this.model.getMasterTrack().toggleIsActivated();
                break;
            }
            case 1: {
                this.model.getMasterTrack().toggleRecArm();
                break;
            }
            case 2: {
                this.model.getMasterTrack().toggleMute();
                break;
            }
            case 3: {
                this.model.getMasterTrack().toggleSolo();
                break;
            }
            case 4: {
                this.model.getMasterTrack().toggleMonitor();
                break;
            }
            case 5: {
                this.model.getMasterTrack().toggleAutoMonitor();
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
                ((ColorView)viewManager.getView(Views.VIEW_COLOR)).setMode(ColorView.SelectMode.MODE_TRACK);
                viewManager.setActiveView(Views.VIEW_COLOR);
            }
        }
    }

    private void onFirstRowTrack(int index) {
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack t = tb.getSelectedTrack();
        if (t == null) {
            return;
        }
        switch (index) {
            case 0: {
                t.toggleIsActivated();
                break;
            }
            case 1: {
                t.toggleRecArm();
                break;
            }
            case 2: {
                t.toggleMute();
                break;
            }
            case 3: {
                t.toggleSolo();
                break;
            }
            case 4: {
                t.toggleMonitor();
                break;
            }
            case 5: {
                t.toggleAutoMonitor();
                break;
            }
            case 6: {
                this.model.toggleCursorTrackPinned();
                break;
            }
            case 7: {
                ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
                ((ColorView)viewManager.getView(Views.VIEW_COLOR)).setMode(ColorView.SelectMode.MODE_TRACK);
                viewManager.setActiveView(Views.VIEW_COLOR);
            }
        }
    }

    @Override
    public void updateFirstRow() {
        ITrack deviceChain = this.getSelectedTrack();
        if (deviceChain == null) {
            this.disableFirstRow();
            return;
        }
        ((PushControlSurface)this.surface).updateButton(20, deviceChain.isActivated() ? (this.isPush2 ? 7 : 16) : (this.isPush2 ? 75 : 13));
        ((PushControlSurface)this.surface).updateButton(21, deviceChain.isRecArm() ? (this.isPush2 ? 127 : 4) : (this.isPush2 ? 66 : 1));
        ((PushControlSurface)this.surface).updateButton(22, deviceChain.isMute() ? (this.isPush2 ? 6 : 10) : (this.isPush2 ? 70 : 7));
        ((PushControlSurface)this.surface).updateButton(23, deviceChain.isSolo() ? (this.isPush2 ? 6 : 10) : (this.isPush2 ? 70 : 7));
        ((PushControlSurface)this.surface).updateButton(24, deviceChain.isMonitor() ? (this.isPush2 ? 126 : 22) : (this.isPush2 ? 10 : 19));
        ((PushControlSurface)this.surface).updateButton(25, deviceChain.isAutoMonitor() ? (this.isPush2 ? 126 : 22) : (this.isPush2 ? 10 : 19));
        ((PushControlSurface)this.surface).updateButton(26, this.model.isCursorTrackPinned() ? (this.isPush2 ? 126 : 22) : (this.isPush2 ? 10 : 19));
        ((PushControlSurface)this.surface).updateButton(27, this.isPush2 ? 126 : 22);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        ITrack deviceChain = this.getSelectedTrack();
        if (deviceChain == null) {
            d.setRow(1, "                     Please selecta track...                        ").clearRow(0).clearRow(2).done(0).done(2);
        } else {
            d.clearRow(0).clearRow(1).setBlock(0, 0, "Track: " + deviceChain.getName());
            d.setCell(2, 0, "Active").setCell(3, 0, deviceChain.isActivated() ? "On" : "Off");
            d.setCell(2, 1, "Rec Arm");
            d.setCell(3, 1, deviceChain.isRecArm() ? "On" : "Off");
            d.setCell(2, 2, "Mute").setCell(3, 2, deviceChain.isMute() ? "On" : "Off");
            d.setCell(2, 3, "Solo").setCell(3, 3, deviceChain.isSolo() ? "On" : "Off");
            d.setCell(2, 4, "Monitor");
            d.setCell(3, 4, deviceChain.isMonitor() ? "On" : "Off");
            d.setCell(2, 5, "Auto Monitor");
            d.setCell(3, 5, deviceChain.isAutoMonitor() ? "On" : "Off");
            boolean hasPinning = this.model.getHost().hasPinning();
            d.setCell(2, 6, hasPinning ? "Pin Trck" : "");
            d.setCell(3, 6, hasPinning ? (this.model.isCursorTrackPinned() ? "On" : "Off") : "");
            d.setCell(2, 7, "Select").setCell(3, 7, "Color").done(0).done(1).done(2).done(3);
        }
    }

    @Override
    public void updateDisplay2() {
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        ITrack deviceChain = this.getSelectedTrack();
        if (deviceChain == null) {
            message.setMessage(3, "Please select a track...");
        } else {
            message.addOptionElement("Track: " + deviceChain.getName(), "", false, "", "Active", deviceChain.isActivated(), false);
            message.addOptionElement("", "", false, "", "Rec Arm", deviceChain.isRecArm(), false);
            message.addOptionElement("", "", false, "", "Mute", deviceChain.isMute(), false);
            message.addOptionElement("", "", false, "", "Solo", deviceChain.isSolo(), false);
            message.addOptionElement("", "", false, "", "Monitor", deviceChain.isMonitor(), false);
            message.addOptionElement("", "", false, "", "Auto Monitor", deviceChain.isAutoMonitor(), false);
            boolean hasPinning = this.model.getHost().hasPinning();
            message.addOptionElement("", "", false, "", hasPinning ? "Pin Track" : "", hasPinning && this.model.isCursorTrackPinned(), false);
            message.addOptionElement("", "", false, "", "Select Color", false, false);
        }
        display.send(message);
    }

    private ITrack getSelectedTrack() {
        ITrack t = this.model.getSelectedTrack();
        if (t != null) {
            return t;
        }
        IMasterTrack master = this.model.getMasterTrack();
        return master.isSelected() ? master : null;
    }
}

