/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.track;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.Pair;

public class SendMode
extends AbstractTrackMode {
    public SendMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.model.getCurrentTrackBank().getTrack(index).getSend(this.getCurrentSendIndex()).changeValue(value);
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        int sendIndex = this.getCurrentSendIndex();
        this.isKnobTouched[index] = isTouched;
        ITrack t = this.model.getCurrentTrackBank().getTrack(index);
        ISend send = t.getSend(sendIndex);
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                send.resetValue();
                return;
            }
            IChannelBank fxTrackBank = this.model.getEffectTrackBank();
            if (t.doesExist()) {
                ((PushControlSurface)this.surface).getDisplay().notify("Send " + (fxTrackBank == null ? send.getName() : fxTrackBank.getTrack(sendIndex).getName()) + ": " + send.getValue());
            }
        }
        send.touchValue(isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        int sendIndex = this.getCurrentSendIndex();
        IChannelBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(i);
            if (t.doesExist()) {
                ISend send = t.getSend(sendIndex);
                d.setCell(0, i, send.getName());
                d.setCell(1, i, send.getDisplayedValue(8));
                d.setCell(2, i, send.getValue(), Format.FORMAT_VALUE);
                continue;
            }
            d.clearColumn(i);
        }
        d.done(0).done(1).done(2);
        this.drawRow4();
    }

    @Override
    public void updateDisplay2() {
        int sendIndex = this.getCurrentSendIndex();
        this.updateTrackMenu(5 + sendIndex % 4);
        IChannelBank tb = this.model.getCurrentTrackBank();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        IValueChanger valueChanger = this.model.getValueChanger();
        int sendOffset = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isSendsAreToggled() ? 4 : 0;
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(i);
            String[] sendName = new String[4];
            String[] valueStr = new String[4];
            int[] value = new int[4];
            int[] modulatedValue = new int[4];
            boolean[] selected = new boolean[4];
            for (int j = 0; j < 4; ++j) {
                int sendPos = sendOffset + j;
                ISend send = t.getSend(sendPos);
                boolean exists = send != null && send.doesExist();
                sendName[j] = exists ? send.getName() : " ";
                valueStr[j] = exists && sendIndex == sendPos && this.isKnobTouched[i] ? send.getDisplayedValue(8) : "";
                value[j] = valueChanger.toDisplayValue(exists ? send.getValue() : -1);
                modulatedValue[j] = valueChanger.toDisplayValue(exists ? send.getModulatedValue() : -1);
                selected[j] = sendIndex == sendPos;
            }
            Pair pair = (Pair)this.menu.get(i);
            message.addSendsElement((String)pair.getKey(), (Boolean)pair.getValue(), t.doesExist() ? t.getName() : "", t.getType(), t.getColor(), t.isSelected(), sendName, valueStr, value, modulatedValue, selected, false);
        }
        display.send(message);
    }

    private int getCurrentSendIndex() {
        return ((PushControlSurface)this.surface).getModeManager().getActiveModeId() - Modes.MODE_SEND1;
    }
}

