/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.track;

import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;

public class PanMode
extends AbstractTrackMode {
    public PanMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.model.getCurrentTrackBank().getTrack(index).changePan(value);
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
        ITrack t = this.model.getCurrentTrackBank().getTrack(index);
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                t.resetPan();
                return;
            }
            if (t.doesExist()) {
                ((PushControlSurface)this.surface).getDisplay().notify("Pan: " + t.getPanStr(8));
            }
        }
        t.touchPan(isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        IChannelBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(i);
            d.setCell(0, i, t.doesExist() ? "Pan" : "").setCell(1, i, t.getPanStr(8));
            if (t.doesExist()) {
                d.setCell(2, i, t.getPan(), Format.FORMAT_PAN);
                continue;
            }
            d.clearCell(2, i);
        }
        d.done(0).done(1).done(2);
        this.drawRow4();
    }

    @Override
    public void updateDisplay2() {
        this.updateChannelDisplay(2, false, true);
    }
}

