/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.track;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MasterMode
extends BaseMode {
    static final String PARAM_NAMES = "Volume   Pan                                       Project:         ";

    public MasterMode(PushControlSurface surface, IModel model, boolean isTemporary) {
        super(surface, model);
        this.isTemporary = isTemporary;
    }

    @Override
    public void onActivate() {
        this.setActive(true);
    }

    @Override
    public void onDeactivate() {
        this.setActive(false);
    }

    @Override
    public void onValueKnob(int index, int value) {
        if (index == 0) {
            this.model.getMasterTrack().changeVolume(value);
        } else if (index == 1) {
            this.model.getMasterTrack().changePan(value);
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                if (index == 0) {
                    this.model.getMasterTrack().resetVolume();
                } else if (index == 1) {
                    this.model.getMasterTrack().resetPan();
                }
                return;
            }
            if (index == 0) {
                ((PushControlSurface)this.surface).getDisplay().notify("Volume: " + this.model.getMasterTrack().getVolumeStr(8));
            } else if (index == 1) {
                ((PushControlSurface)this.surface).getDisplay().notify("Pan: " + this.model.getMasterTrack().getPanStr(8));
            }
        }
        if (index == 0) {
            this.model.getMasterTrack().touchVolume(isTouched);
        } else if (index == 1) {
            this.model.getMasterTrack().touchPan(isTouched);
        }
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        IMasterTrack master = this.model.getMasterTrack();
        d.setRow(0, PARAM_NAMES).setCell(1, 0, master.getVolumeStr(8)).setCell(1, 1, master.getPanStr(8));
        d.clearCell(1, 2).clearCell(1, 3).setBlock(1, 2, "Audio Engine").setBlock(1, 3, this.model.getProject().getName()).done(1);
        d.setCell(2, 0, ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isEnableVUMeters() ? master.getVu() : master.getVolume(), Format.FORMAT_VALUE);
        d.setCell(2, 1, master.getPan(), Format.FORMAT_PAN).clearCell(2, 2).clearCell(2, 3).clearCell(2, 4).clearCell(2, 5).clearCell(2, 6).clearCell(2, 7).done(2);
        d.setCell(3, 0, master.getName()).clearCell(3, 1).clearCell(3, 2).clearCell(3, 3).setCell(3, 4, this.model.getApplication().isEngineActive() ? "Active" : "Off");
        d.clearCell(3, 5).setCell(3, 6, "Previous").setCell(3, 7, "Next").done(3);
    }

    @Override
    public void updateDisplay2() {
        IMasterTrack master = this.model.getMasterTrack();
        IValueChanger valueChanger = this.model.getValueChanger();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        message.addChannelElement("Volume", false, master.getName(), ChannelType.MASTER, master.getColor(), master.isSelected(), valueChanger.toDisplayValue(master.getVolume()), valueChanger.toDisplayValue(master.getModulatedVolume()), this.isKnobTouched[0] ? master.getVolumeStr(8) : "", valueChanger.toDisplayValue(master.getPan()), valueChanger.toDisplayValue(master.getModulatedPan()), this.isKnobTouched[1] ? master.getPanStr(8) : "", valueChanger.toDisplayValue(((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isEnableVUMeters() ? master.getVu() : 0), master.isMute(), master.isSolo(), master.isRecArm(), 0);
        for (int i = 1; i < 4; ++i) {
            message.addChannelSelectorElement(i == 1 ? "Pan" : "", false, "", null, new double[]{0.0, 0.0, 0.0}, false);
        }
        message.addOptionElement("", "", false, "Audio Engine", this.model.getApplication().isEngineActive() ? "Active" : "Off", false, false);
        message.addOptionElement("", "", false, "", "", false, false);
        message.addOptionElement("Project:", "", false, this.model.getProject().getName(), "Previous", false, false);
        message.addOptionElement("", "", false, "", "Next", false, false);
        display.send(message);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (((PushControlSurface)this.surface).isPressed(86)) {
            ((PushControlSurface)this.surface).setButtonConsumed(86);
            this.model.getMasterTrack().toggleRecArm();
            return;
        }
        switch (index) {
            case 0: {
                ((PushControlSurface)this.surface).getViewManager().getActiveView().executeTriggerCommand(Commands.COMMAND_DEVICE, ButtonEvent.DOWN);
                break;
            }
            case 4: {
                this.model.getApplication().toggleEngineActive();
                break;
            }
            case 6: {
                this.model.getProject().previous();
                break;
            }
            case 7: {
                this.model.getProject().next();
            }
        }
    }

    @Override
    public void updateFirstRow() {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        ((PushControlSurface)this.surface).updateButton(20, this.getTrackButtonColor());
        for (int i = 1; i < 4; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, "BUTTON_COLOR_OFF");
        }
        int red = isPush2 ? 127 : 4;
        ((PushControlSurface)this.surface).updateButton(24, this.model.getApplication().isEngineActive() ? this.model.getColorManager().getColor("BUTTON_COLOR_ON") : red);
        ((PushControlSurface)this.surface).updateButton(25, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(26, "BUTTON_COLOR_ON");
        ((PushControlSurface)this.surface).updateButton(27, "BUTTON_COLOR_ON");
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.isPush2) {
            return;
        }
        if (index > 0) {
            return;
        }
        IMasterTrack master = this.model.getMasterTrack();
        if (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isMuteState()) {
            master.toggleMute();
        } else {
            master.toggleSolo();
        }
    }

    @Override
    public void updateSecondRow() {
        int off;
        int n = off = this.isPush2 ? 0 : 0;
        if (this.isPush2) {
            for (int i = 0; i < 8; ++i) {
                ((PushControlSurface)this.surface).updateButton(102 + i, off);
            }
            return;
        }
        boolean muteState = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isMuteState();
        IMasterTrack master = this.model.getMasterTrack();
        int color = off;
        if (muteState) {
            if (!master.isMute()) {
                color = this.isPush2 ? 7 : 13;
            }
        } else {
            color = master.isSolo() ? (this.isPush2 ? 95 : 45) : (this.isPush2 ? 124 : 1);
        }
        ((PushControlSurface)this.surface).updateButton(102, color);
        for (int i = 1; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(102 + i, off);
        }
    }

    private int getTrackButtonColor() {
        IMasterTrack track = this.model.getMasterTrack();
        if (!track.isActivated()) {
            return this.isPush2 ? 0 : 0;
        }
        if (track.isRecArm()) {
            return this.isPush2 ? 127 : 4;
        }
        return this.isPush2 ? 6 : 10;
    }

    private void setActive(boolean enable) {
        IMasterTrack mt = this.model.getMasterTrack();
        mt.setVolumeIndication(enable);
        mt.setPanIndication(enable);
    }
}

