/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.track;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.view.ColorView;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ViewManager;

public class LayerDetailsMode
extends BaseMode {
    public LayerDetailsMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IChannel deviceChain = this.model.getCursorDevice().getSelectedLayerOrDrumPad();
        if (deviceChain == null) {
            return;
        }
        switch (index) {
            case 0: {
                this.model.getCursorDevice().toggleLayerOrDrumPadIsActivated(deviceChain.getIndex());
                break;
            }
            case 2: {
                this.model.getCursorDevice().toggleLayerOrDrumPadMute(deviceChain.getIndex());
                break;
            }
            case 3: {
                this.model.getCursorDevice().toggleLayerOrDrumPadSolo(deviceChain.getIndex());
                break;
            }
            case 7: {
                ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
                ((ColorView)viewManager.getView(Views.VIEW_COLOR)).setMode(ColorView.SelectMode.MODE_LAYER);
                viewManager.setActiveView(Views.VIEW_COLOR);
                break;
            }
        }
    }

    @Override
    public void updateFirstRow() {
        IChannel deviceChain = this.model.getCursorDevice().getSelectedLayerOrDrumPad();
        if (deviceChain == null) {
            this.disableFirstRow();
            return;
        }
        int off = this.isPush2 ? 0 : 0;
        ((PushControlSurface)this.surface).updateButton(20, deviceChain.isActivated() ? (this.isPush2 ? 7 : 16) : (this.isPush2 ? 75 : 13));
        ((PushControlSurface)this.surface).updateButton(21, off);
        ((PushControlSurface)this.surface).updateButton(22, deviceChain.isMute() ? (this.isPush2 ? 6 : 10) : (this.isPush2 ? 70 : 7));
        ((PushControlSurface)this.surface).updateButton(23, deviceChain.isSolo() ? (this.isPush2 ? 6 : 10) : (this.isPush2 ? 70 : 7));
        ((PushControlSurface)this.surface).updateButton(24, off);
        ((PushControlSurface)this.surface).updateButton(25, off);
        ((PushControlSurface)this.surface).updateButton(26, off);
        ((PushControlSurface)this.surface).updateButton(27, this.isPush2 ? 126 : 22);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        IChannel deviceChain = this.model.getCursorDevice().getSelectedLayerOrDrumPad();
        if (deviceChain == null) {
            d.setRow(1, "                     Please selecta layer...                        ").clearRow(0).clearRow(2).done(0).done(2);
        } else {
            d.clearRow(0).clearRow(1).setBlock(0, 0, "Layer: " + deviceChain.getName());
            d.setCell(2, 0, "Active").setCell(3, 0, deviceChain.isActivated() ? "On" : "Off");
            d.setCell(2, 1, "");
            d.setCell(3, 1, "");
            d.setCell(2, 2, "Mute").setCell(3, 2, deviceChain.isMute() ? "On" : "Off");
            d.setCell(2, 3, "Solo").setCell(3, 3, deviceChain.isSolo() ? "On" : "Off");
            d.setCell(2, 4, "");
            d.setCell(3, 4, "");
            d.setCell(2, 5, "");
            d.setCell(3, 5, "");
            d.clearCell(2, 6).clearCell(3, 6);
            d.setCell(2, 7, "Select").setCell(3, 7, "Color").done(0).done(1).done(2).done(3);
        }
    }

    @Override
    public void updateDisplay2() {
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        IChannel deviceChain = this.model.getCursorDevice().getSelectedLayerOrDrumPad();
        if (deviceChain == null) {
            message.setMessage(3, "Please select a layer...");
        } else {
            message.addOptionElement("Layer: " + deviceChain.getName(), "", false, "", "Active", deviceChain.isActivated(), false);
            message.addEmptyElement();
            message.addOptionElement("", "", false, "", "Mute", deviceChain.isMute(), false);
            message.addOptionElement("", "", false, "", "Solo", deviceChain.isSolo(), false);
            message.addEmptyElement();
            message.addEmptyElement();
            message.addEmptyElement();
            message.addOptionElement("", "", false, "", "Select Color", false, false);
        }
        display.send(message);
    }
}

