/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.track;

import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;

public class CrossfaderMode
extends AbstractTrackMode {
    public CrossfaderMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        ITrack t;
        this.isKnobTouched[index] = isTouched;
        if (isTouched && (t = this.model.getCurrentTrackBank().getTrack(index)).doesExist()) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                t.setCrossfadeMode("AB");
                return;
            }
            ((PushControlSurface)this.surface).getDisplay().notify("Crossfader: " + t.getCrossfadeMode());
        }
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void onValueKnob(int index, int value) {
        if (this.increaseKnobMovement()) {
            this.model.getCurrentTrackBank().getTrack(index).changeCrossfadeModeAsNumber(value);
        }
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        IChannelBank tb = this.model.getCurrentTrackBank();
        int upperBound = this.model.getValueChanger().getUpperBound();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(i);
            d.setCell(0, i, t.doesExist() ? "Crossfdr" : "");
            if (t.doesExist()) {
                boolean isA = "A".equals(t.getCrossfadeMode());
                d.setCell(1, i, isA ? "A" : ("B".equals(t.getCrossfadeMode()) ? "       B" : "   <> "));
                d.setCell(2, i, isA ? 0 : ("B".equals(t.getCrossfadeMode()) ? upperBound : upperBound / 2), Format.FORMAT_PAN);
                continue;
            }
            d.clearCell(1, i);
            d.clearCell(2, i);
        }
        d.done(0).done(1).done(2);
        this.drawRow4();
    }

    @Override
    public void updateDisplay2() {
        this.updateChannelDisplay(3, false, false);
    }
}

