/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.track;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.mode.track.AbstractTrackMode;
import de.mossgrabers.controller.push.view.ColorView;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.ViewManager;

public class ClipMode
extends AbstractTrackMode {
    private boolean displayMidiNotes = false;

    public ClipMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
        if (index == 7 && isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
            this.model.getCursorClip().resetAccent();
        }
    }

    @Override
    public void onValueKnob(int index, int value) {
        if (!this.increaseKnobMovement()) {
            return;
        }
        ICursorClip clip = this.model.getCursorClip();
        switch (index) {
            case 0: {
                clip.changePlayStart(value);
                break;
            }
            case 1: {
                clip.changePlayEnd(value);
                break;
            }
            case 2: {
                clip.changeLoopStart(value);
                break;
            }
            case 3: {
                clip.changeLoopLength(value);
                break;
            }
            case 4: {
                clip.setLoopEnabled(value <= 61);
                break;
            }
            case 6: {
                clip.setShuffleEnabled(value <= 61);
                break;
            }
            case 7: {
                clip.changeAccent(value);
                break;
            }
        }
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        ICursorClip clip = this.model.getCursorClip();
        d.setCell(0, 0, "PlayStrt").setCell(1, 0, this.formatMeasures(clip.getPlayStart(), 1));
        d.setCell(0, 1, "Play End").setCell(1, 1, this.formatMeasures(clip.getPlayEnd(), 1));
        d.setCell(0, 2, "LoopStrt").setCell(1, 2, this.formatMeasures(clip.getLoopStart(), 1));
        d.setCell(0, 3, "LopLngth").setCell(1, 3, this.formatMeasures(clip.getLoopLength(), 0));
        d.setCell(0, 4, "Loop").setCell(1, 4, clip.isLoopEnabled() ? "On" : "Off").clearCell(0, 5).clearCell(1, 5);
        d.setCell(0, 6, "Shuffle").setCell(1, 6, clip.isShuffleEnabled() ? "On" : "Off");
        d.setCell(0, 7, "Accent").setCell(1, 7, clip.getFormattedAccent()).done(0).done(1).clearRow(2).done(2);
        this.drawRow4();
    }

    @Override
    public void updateDisplay2() {
        ICursorClip clip = this.model.getCursorClip();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        if (this.displayMidiNotes) {
            message.setMidiClipElement(clip, this.model.getTransport().getQuartersPerMeasure());
            display.send(message);
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack t0 = tb.getTrack(0);
        ITrack t1 = tb.getTrack(1);
        ITrack t2 = tb.getTrack(2);
        ITrack t3 = tb.getTrack(3);
        ITrack t4 = tb.getTrack(4);
        ITrack t5 = tb.getTrack(5);
        ITrack t6 = tb.getTrack(6);
        ITrack t7 = tb.getTrack(7);
        message.addParameterElement(this.model.getHost().hasClips() ? "Session" : "", this.displayMidiNotes, t0.getName(), t0.getType(), t0.getColor(), t0.isSelected(), "Play Start", -1, this.formatMeasures(clip.getPlayStart(), 1), this.isKnobTouched[0], -1);
        message.addParameterElement("Piano Roll", false, t1.getName(), t1.getType(), t1.getColor(), t1.isSelected(), "Play End", -1, this.formatMeasures(clip.getPlayEnd(), 1), this.isKnobTouched[1], -1);
        message.addParameterElement("", false, t2.getName(), t2.getType(), t2.getColor(), t2.isSelected(), "Loop Start", -1, this.formatMeasures(clip.getLoopStart(), 1), this.isKnobTouched[2], -1);
        message.addParameterElement("", false, t3.getName(), t3.getType(), t3.getColor(), t3.isSelected(), "Loop Lngth", -1, this.formatMeasures(clip.getLoopLength(), 0), this.isKnobTouched[3], -1);
        message.addParameterElement("", false, t4.getName(), t4.getType(), t4.getColor(), t4.isSelected(), "Loop", -1, clip.isLoopEnabled() ? "On" : "Off", this.isKnobTouched[4], -1);
        message.addParameterElement("", false, t5.getName(), t5.getType(), t5.getColor(), t5.isSelected(), "", -1, "", false, -1);
        message.addParameterElement("", false, t6.getName(), t6.getType(), t6.getColor(), t6.isSelected(), "Shuffle", -1, clip.isShuffleEnabled() ? "On" : "Off", this.isKnobTouched[6], -1);
        message.addParameterElement("Select color", false, t7.getName(), t7.getType(), t7.getColor(), t7.isSelected(), "Accent", -1, clip.getFormattedAccent(), this.isKnobTouched[7], -1);
        display.send(message);
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.displayMidiNotes) {
            this.displayMidiNotes = false;
            return;
        }
        switch (index) {
            case 0: {
                if (!this.model.getHost().hasClips()) break;
                ((PushControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_SESSION);
                break;
            }
            case 1: {
                if (!this.isPush2) break;
                this.displayMidiNotes = !this.displayMidiNotes;
                break;
            }
            case 7: {
                ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
                ((ColorView)viewManager.getView(Views.VIEW_COLOR)).setMode(ColorView.SelectMode.MODE_CLIP);
                viewManager.setActiveView(Views.VIEW_COLOR);
                break;
            }
        }
    }

    @Override
    public void updateSecondRow() {
        ((PushControlSurface)this.surface).updateButton(102, this.displayMidiNotes ? 0 : 120);
        ((PushControlSurface)this.surface).updateButton(103, this.isPush2 && !this.displayMidiNotes ? 120 : 0);
        ((PushControlSurface)this.surface).updateButton(104, 0);
        ((PushControlSurface)this.surface).updateButton(105, 0);
        ((PushControlSurface)this.surface).updateButton(106, 0);
        ((PushControlSurface)this.surface).updateButton(107, 0);
        ((PushControlSurface)this.surface).updateButton(108, 0);
        ((PushControlSurface)this.surface).updateButton(109, this.displayMidiNotes ? 0 : 120);
    }

    private String formatMeasures(double time, int startOffset) {
        return StringUtils.formatMeasures(this.model.getTransport().getQuartersPerMeasure(), time, startOffset);
    }
}

