/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.track;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTrackMode
extends BaseMode {
    protected final List<Pair<String, Boolean>> menu = new ArrayList<Pair<String, Boolean>>();

    public AbstractTrackMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
        for (int i = 0; i < 8; ++i) {
            this.menu.add(new Pair<String, Boolean>(" ", Boolean.FALSE));
        }
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack track = tb.getTrack(index);
        if (event == ButtonEvent.UP) {
            if (((PushControlSurface)this.surface).isPressed(88)) {
                ((PushControlSurface)this.surface).setButtonConsumed(88);
                track.duplicate();
                return;
            }
            if (((PushControlSurface)this.surface).isPressed(29)) {
                ((PushControlSurface)this.surface).setButtonConsumed(29);
                track.stop();
                return;
            }
            if (((PushControlSurface)this.surface).isPressed(86)) {
                ((PushControlSurface)this.surface).setButtonConsumed(86);
                track.toggleRecArm();
                return;
            }
            ITrack selTrack = tb.getSelectedTrack();
            if (selTrack != null && selTrack.getIndex() == index) {
                if (selTrack.isGroup() && tb instanceof ITrackBank) {
                    ((ITrackBank)tb).selectChildren();
                } else {
                    ((PushControlSurface)this.surface).getViewManager().getActiveView().executeTriggerCommand(Commands.COMMAND_DEVICE, ButtonEvent.DOWN);
                }
            } else {
                track.selectAndMakeVisible();
            }
            return;
        }
        if (!this.model.isEffectTrackBankActive()) {
            this.model.getTrackBank().selectParent();
            ((PushControlSurface)this.surface).setButtonConsumed(20 + index);
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack track = tb.getTrack(index);
        if (((PushControlSurface)this.surface).isPressed(29)) {
            track.stop();
            return;
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (!this.isPush2 || config.isMuteLongPressed() || config.isSoloLongPressed() || config.isMuteSoloLocked()) {
            if (config.isMuteState()) {
                track.toggleMute();
            } else {
                track.toggleSolo();
            }
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        switch (index) {
            case 0: {
                if (modeManager.isActiveMode(Modes.MODE_VOLUME)) {
                    modeManager.setActiveMode(Modes.MODE_TRACK);
                    break;
                }
                modeManager.setActiveMode(Modes.MODE_VOLUME);
                break;
            }
            case 1: {
                if (modeManager.isActiveMode(Modes.MODE_PAN)) {
                    modeManager.setActiveMode(Modes.MODE_TRACK);
                    break;
                }
                modeManager.setActiveMode(Modes.MODE_PAN);
                break;
            }
            case 2: {
                if (!config.isDisplayCrossfader()) break;
                if (modeManager.isActiveMode(Modes.MODE_CROSSFADER)) {
                    modeManager.setActiveMode(Modes.MODE_TRACK);
                    break;
                }
                modeManager.setActiveMode(Modes.MODE_CROSSFADER);
                break;
            }
            case 3: {
                if (this.model.isEffectTrackBankActive()) break;
                config.setSendsAreToggled(!config.isSendsAreToggled());
                if (modeManager.isActiveMode(Modes.MODE_TRACK)) break;
                modeManager.setActiveMode(Modes.MODE_SEND1 + (config.isSendsAreToggled() ? 4 : 0));
                break;
            }
            case 7: {
                if (this.model.isEffectTrackBankActive()) break;
                if (((PushControlSurface)this.surface).isShiftPressed()) {
                    this.handleSendEffect(config.isSendsAreToggled() ? 7 : 3);
                    break;
                }
                this.model.getTrackBank().selectParent();
                break;
            }
            default: {
                this.handleSendEffect(index - (config.isSendsAreToggled() ? 0 : 4));
            }
        }
        config.setDebugMode(modeManager.getActiveModeId());
    }

    protected void handleSendEffect(int sendIndex) {
        ModeManager modeManager;
        IChannelBank tb = this.model.getCurrentTrackBank();
        if (tb == null || !tb.canEditSend(sendIndex)) {
            return;
        }
        Integer si = Modes.MODE_SEND1 + sendIndex;
        modeManager.setActiveMode((modeManager = ((PushControlSurface)this.surface).getModeManager()).isActiveMode(si) ? Modes.MODE_TRACK : si);
    }

    @Override
    public void updateFirstRow() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, this.getTrackButtonColor(tb.getTrack(i)));
        }
    }

    @Override
    public void updateSecondRow() {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        IChannelBank tb = this.model.getCurrentTrackBank();
        if (this.isPush2) {
            if (((PushControlSurface)this.surface).isPressed(29)) {
                for (int i = 0; i < 8; ++i) {
                    ITrack track = tb.getTrack(i);
                    ((PushControlSurface)this.surface).updateButton(102 + i, track.doesExist() && track.isPlaying() ? 127 : 0);
                }
                return;
            }
            if (config.isMuteLongPressed() || config.isSoloLongPressed() || config.isMuteSoloLocked()) {
                boolean muteState = config.isMuteState();
                for (int i = 0; i < 8; ++i) {
                    ((PushControlSurface)this.surface).updateButton(102 + i, this.getTrackStateColor(muteState, tb.getTrack(i)));
                }
                return;
            }
            ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
            ((PushControlSurface)this.surface).updateButton(102, modeManager.isActiveMode(Modes.MODE_VOLUME) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(103, modeManager.isActiveMode(Modes.MODE_PAN) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(104, modeManager.isActiveMode(Modes.MODE_CROSSFADER) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(105, 0);
            boolean sendsAreToggled = config.isSendsAreToggled();
            ((PushControlSurface)this.surface).updateButton(106, modeManager.isActiveMode(sendsAreToggled ? Modes.MODE_SEND5 : Modes.MODE_SEND1) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(107, modeManager.isActiveMode(sendsAreToggled ? Modes.MODE_SEND6 : Modes.MODE_SEND2) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(108, modeManager.isActiveMode(sendsAreToggled ? Modes.MODE_SEND7 : Modes.MODE_SEND3) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(109, tb instanceof ITrackBank && ((ITrackBank)tb).hasParent() ? 120 : 0);
            return;
        }
        boolean muteState = config.isMuteState();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(i);
            int color = 0;
            if (t.doesExist()) {
                if (muteState) {
                    if (!t.isMute()) {
                        color = 13;
                    }
                } else {
                    color = t.isSolo() ? 45 : 1;
                }
            }
            ((PushControlSurface)this.surface).updateButton(102 + i, color);
        }
    }

    protected int getTrackStateColor(boolean muteState, ITrack t) {
        if (!t.doesExist()) {
            return 0;
        }
        if (muteState) {
            if (t.isMute()) {
                return 70;
            }
        } else if (t.isSolo()) {
            return 7;
        }
        return 0;
    }

    protected void drawRow4() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack selTrack = tb.getSelectedTrack();
        int selIndex = selTrack == null ? -1 : selTrack.getIndex();
        Display d = ((PushControlSurface)this.surface).getDisplay();
        for (int i = 0; i < 8; ++i) {
            boolean isSel = i == selIndex;
            ITrack t = tb.getTrack(i);
            String n = StringUtils.shortenAndFixASCII(t.getName(), isSel ? 7 : 8);
            d.setCell(3, i, isSel ? PushDisplay.RIGHT_ARROW + n : n);
        }
        d.done(3);
    }

    protected int getTrackButtonColor(ITrack track) {
        boolean isSel;
        if (!track.doesExist() || !track.isActivated()) {
            return this.isPush2 ? 0 : 0;
        }
        ITrack selTrack = this.model.getSelectedTrack();
        int selIndex = selTrack == null ? -1 : selTrack.getIndex();
        boolean bl = isSel = track.getIndex() == selIndex;
        if (track.isRecArm()) {
            return isSel ? (this.isPush2 ? 127 : 4) : (this.isPush2 ? 66 : 1);
        }
        return isSel ? (this.isPush2 ? 6 : 10) : (this.isPush2 ? 75 : 13);
    }

    protected void updateChannelDisplay(int selectedMenu, boolean isVolume, boolean isPan) {
        this.updateMenuItems(selectedMenu);
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        IValueChanger valueChanger = this.model.getValueChanger();
        IChannelBank tb = this.model.getCurrentTrackBank();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        boolean displayCrossfader = config.isDisplayCrossfader();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(i);
            Pair<String, Boolean> pair = this.menu.get(i);
            String topMenu = pair.getKey();
            boolean isTopMenuOn = pair.getValue();
            int crossfadeMode = displayCrossfader ? t.getCrossfadeModeAsNumber() : -1;
            message.addChannelElement(selectedMenu, topMenu, isTopMenuOn, t.doesExist() ? t.getName(12) : "", t.getType(), t.getColor(), t.isSelected(), valueChanger.toDisplayValue(t.getVolume()), valueChanger.toDisplayValue(t.getModulatedVolume()), isVolume && this.isKnobTouched[i] ? t.getVolumeStr(8) : "", valueChanger.toDisplayValue(t.getPan()), valueChanger.toDisplayValue(t.getModulatedPan()), isPan && this.isKnobTouched[i] ? t.getPanStr() : "", valueChanger.toDisplayValue(config.isEnableVUMeters() ? t.getVu() : 0), t.isMute(), t.isSolo(), t.isRecArm(), crossfadeMode);
        }
        display.send(message);
    }

    protected void updateMenuItems(int selectedMenu) {
        if (((PushControlSurface)this.surface).isPressed(29) && this.model.getHost().hasClips()) {
            this.updateStopMenu();
            return;
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (config.isMuteLongPressed() || config.isMuteSoloLocked() && config.isMuteState()) {
            this.updateMuteMenu();
        } else if (config.isSoloLongPressed() || config.isMuteSoloLocked() && config.isSoloState()) {
            this.updateSoloMenu();
        } else {
            this.updateTrackMenu(selectedMenu);
        }
    }

    protected void updateStopMenu() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t;
            this.menu.get(i).set((t = tb.getTrack(i)).doesExist() ? "Stop Clip" : "", t.isPlaying());
        }
    }

    protected void updateMuteMenu() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t;
            this.menu.get(i).set((t = tb.getTrack(i)).doesExist() ? "Mute" : "", t.isMute());
        }
    }

    protected void updateSoloMenu() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t;
            this.menu.get(i).set((t = tb.getTrack(i)).doesExist() ? "Solo" : "", t.isSolo());
        }
    }

    protected void updateTrackMenu(int selectedMenu) {
        boolean sendsAreToggled;
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        this.menu.get(0).set("Volume", selectedMenu - 1 == 0);
        this.menu.get(1).set("Pan", selectedMenu - 1 == 1);
        this.menu.get(2).set(config.isDisplayCrossfader() ? "Crossfader" : " ", selectedMenu - 1 == 2);
        if (this.model.isEffectTrackBankActive()) {
            for (int i = 3; i < 7; ++i) {
                this.menu.get(i).set(" ", Boolean.FALSE);
            }
            return;
        }
        this.menu.get(3).set((sendsAreToggled = config.isSendsAreToggled()) ? "Sends 5-8" : "Sends 1-4", sendsAreToggled);
        IChannelBank tb = this.model.getCurrentTrackBank();
        int sendOffset = sendsAreToggled ? 4 : 0;
        boolean isShiftPressed = ((PushControlSurface)this.surface).isShiftPressed();
        for (int i = 0; i < (isShiftPressed ? 4 : 3); ++i) {
            String sendName;
            this.menu.get(4 + i).set((sendName = tb.getEditSendName(sendOffset + i)).isEmpty() ? " " : sendName, 4 + i == selectedMenu - 1);
        }
        if (isShiftPressed) {
            return;
        }
        boolean isUpAvailable = tb instanceof ITrackBank && ((ITrackBank)tb).hasParent();
        this.menu.get(7).set(isUpAvailable ? "Up" : " ", isUpAvailable);
    }
}

