/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.device;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IParameter;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.View;

public class DeviceParamsMode
extends BaseMode {
    private static final String[] MENU = new String[]{"On", "Parameters", "Expanded", null, "Banks", "Pin Device", "Window", "Up"};
    private boolean showDevices;

    public DeviceParamsMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
        this.showDevices = true;
    }

    public void setShowDevices(boolean enable) {
        this.showDevices = enable;
    }

    public boolean isShowDevices() {
        return this.showDevices;
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.model.getCursorDevice().changeParameter(index, value);
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
        ICursorDevice cd = this.model.getCursorDevice();
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                cd.resetParameter(index);
                return;
            }
            IParameter param = cd.getFXParam(index);
            if (!param.getName().isEmpty()) {
                ((PushControlSurface)this.surface).getDisplay().notify(param.getName() + ": " + param.getDisplayedValue());
            }
        }
        cd.touchParameter(index, isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            return;
        }
        if (event == ButtonEvent.UP) {
            ICursorDevice cd = this.model.getCursorDevice();
            if (!cd.hasSelectedDevice()) {
                return;
            }
            if (!this.showDevices) {
                cd.setSelectedParameterPageInBank(index);
                return;
            }
            if (cd.getPositionInBank() != index) {
                cd.selectSibling(index);
                return;
            }
            ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
            if (!cd.hasLayers()) {
                ((DeviceParamsMode)modeManager.getMode(Modes.MODE_DEVICE_PARAMS)).setShowDevices(false);
                return;
            }
            IChannel layer = cd.getSelectedLayerOrDrumPad();
            if (layer == null) {
                cd.selectLayerOrDrumPad(0);
            }
            modeManager.setActiveMode(Modes.MODE_DEVICE_LAYER);
            return;
        }
        ((PushControlSurface)this.surface).setButtonConsumed(20 + index);
        this.moveUp();
    }

    protected void moveUp() {
        ICursorDevice cd = this.model.getCursorDevice();
        View activeView = ((PushControlSurface)this.surface).getViewManager().getActiveView();
        if (!cd.hasSelectedDevice()) {
            activeView.executeTriggerCommand(Commands.COMMAND_TRACK, ButtonEvent.DOWN);
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        DeviceParamsMode deviceParamsMode = (DeviceParamsMode)modeManager.getMode(Modes.MODE_DEVICE_PARAMS);
        if (!deviceParamsMode.isShowDevices()) {
            deviceParamsMode.setShowDevices(true);
            return;
        }
        if (cd.isNested()) {
            cd.selectParent();
            modeManager.setActiveMode(Modes.MODE_DEVICE_LAYER);
            deviceParamsMode.setShowDevices(false);
            cd.selectChannel();
            return;
        }
        if (this.model.isCursorDeviceOnMasterTrack()) {
            activeView.executeTriggerCommand(Commands.COMMAND_MASTERTRACK, ButtonEvent.DOWN);
            activeView.executeTriggerCommand(Commands.COMMAND_MASTERTRACK, ButtonEvent.UP);
        } else {
            activeView.executeTriggerCommand(Commands.COMMAND_TRACK, ButtonEvent.DOWN);
        }
    }

    @Override
    public void updateFirstRow() {
        int offColor;
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.hasSelectedDevice()) {
            this.disableFirstRow();
            return;
        }
        int selectedColor = this.isPush2 ? 6 : 10;
        int existsColor = this.isPush2 ? 75 : 13;
        int n = offColor = this.isPush2 ? 0 : 0;
        if (this.showDevices) {
            for (int i = 0; i < 8; ++i) {
                ((PushControlSurface)this.surface).updateButton(20 + i, cd.doesSiblingExist(i) ? (i == cd.getPositionInBank() ? selectedColor : existsColor) : offColor);
            }
        } else {
            String[] pages = cd.getParameterPageNames();
            int page = Math.min(Math.max(0, cd.getSelectedParameterPage()), pages.length - 1);
            int start = page / 8 * 8;
            for (int i = 0; i < 8; ++i) {
                int index = start + i;
                ((PushControlSurface)this.surface).updateButton(20 + i, index < pages.length ? (index == page ? selectedColor : existsColor) : offColor);
            }
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice device = this.model.getCursorDevice();
        switch (index) {
            case 0: {
                if (!device.hasSelectedDevice()) break;
                device.toggleEnabledState();
                break;
            }
            case 1: {
                if (!device.hasSelectedDevice()) break;
                device.toggleParameterPageSectionVisible();
                break;
            }
            case 2: {
                if (!device.hasSelectedDevice()) break;
                device.toggleExpanded();
                break;
            }
            case 4: {
                if (!device.hasSelectedDevice()) break;
                this.showDevices = !this.showDevices;
                break;
            }
            case 5: {
                if (!device.hasSelectedDevice()) break;
                device.togglePinned();
                break;
            }
            case 6: {
                if (!device.hasSelectedDevice()) break;
                device.toggleWindowOpen();
                break;
            }
            case 7: {
                this.moveUp();
            }
        }
    }

    @Override
    public void updateSecondRow() {
        int white = this.isPush2 ? 120 : 3;
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.hasSelectedDevice()) {
            this.disableSecondRow();
            ((PushControlSurface)this.surface).updateButton(109, white);
            return;
        }
        int green = this.isPush2 ? 83 : 22;
        int grey = this.isPush2 ? 124 : 1;
        int orange = this.isPush2 ? 65 : 65;
        int off = this.isPush2 ? 0 : 0;
        int turquoise = this.isPush2 ? 31 : 31;
        ((PushControlSurface)this.surface).updateButton(102, cd.isEnabled() ? green : grey);
        ((PushControlSurface)this.surface).updateButton(103, cd.isParameterPageSectionVisible() ? orange : white);
        ((PushControlSurface)this.surface).updateButton(104, cd.isExpanded() ? orange : white);
        ((PushControlSurface)this.surface).updateButton(105, off);
        ((PushControlSurface)this.surface).updateButton(106, this.showDevices ? white : orange);
        ((PushControlSurface)this.surface).updateButton(107, this.model.getHost().hasPinning() ? (cd.isPinned() ? turquoise : grey) : off);
        ((PushControlSurface)this.surface).updateButton(108, cd.isWindowOpen() ? turquoise : grey);
        ((PushControlSurface)this.surface).updateButton(109, white);
    }

    @Override
    public void updateDisplay1() {
        int i;
        Display d = ((PushControlSurface)this.surface).getDisplay().clear();
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.hasSelectedDevice()) {
            d.clear().setBlock(1, 0, "           Select").setBlock(1, 1, "a device or press").setBlock(1, 2, "'Add Effect'...  ").allDone();
            return;
        }
        for (i = 0; i < 8; ++i) {
            IParameter param = cd.getFXParam(i);
            d.setCell(0, i, param.doesExist() ? StringUtils.fixASCII(param.getName()) : "").setCell(1, i, param.getDisplayedValue(8));
        }
        d.setBlock(2, 0, "Selected Device:").setBlock(2, 1, cd.getName());
        if (this.showDevices) {
            for (i = 0; i < 8; ++i) {
                d.setCell(3, i, cd.doesSiblingExist(i) ? (i == cd.getPositionInBank() ? PushDisplay.RIGHT_ARROW : "") + cd.getSiblingDeviceName(i) : "");
            }
        } else {
            String[] pages = cd.getParameterPageNames();
            int page = Math.min(Math.max(0, cd.getSelectedParameterPage()), pages.length - 1);
            int start = page / 8 * 8;
            for (int i2 = 0; i2 < 8; ++i2) {
                int index = start + i2;
                d.setCell(3, i2, index < pages.length ? (index == page ? PushDisplay.RIGHT_ARROW : "") + pages[index] : "");
            }
        }
        d.allDone();
    }

    @Override
    public void updateDisplay2() {
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.hasSelectedDevice()) {
            for (int i = 0; i < 8; ++i) {
                message.addOptionElement(i == 2 ? "Please select a device or press 'Add Device'..." : "", i == 7 ? "Up" : "", true, "", "", false, true);
            }
            display.send(message);
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        String color = tb.getSelectedTrackColorEntry();
        IValueChanger valueChanger = this.model.getValueChanger();
        String[] pages = cd.getParameterPageNames();
        int page = Math.min(Math.max(0, cd.getSelectedParameterPage()), pages.length - 1);
        int start = page / 8 * 8;
        boolean hasPinning = this.model.getHost().hasPinning();
        for (int i = 0; i < 8; ++i) {
            boolean isBottomMenuOn;
            String bottomMenu;
            boolean isTopMenuOn;
            switch (i) {
                case 0: {
                    isTopMenuOn = cd.isEnabled();
                    break;
                }
                case 1: {
                    isTopMenuOn = cd.isParameterPageSectionVisible();
                    break;
                }
                case 2: {
                    isTopMenuOn = cd.isExpanded();
                    break;
                }
                case 4: {
                    isTopMenuOn = !this.showDevices;
                    break;
                }
                case 5: {
                    isTopMenuOn = hasPinning && cd.isPinned();
                    break;
                }
                case 6: {
                    isTopMenuOn = cd.isWindowOpen();
                    break;
                }
                case 7: {
                    isTopMenuOn = true;
                    break;
                }
                default: {
                    isTopMenuOn = false;
                }
            }
            String bottomMenuIcon = "";
            if (this.showDevices) {
                bottomMenu = cd.doesSiblingExist(i) ? cd.getSiblingDeviceName(i, 12) : "";
                isBottomMenuOn = i == cd.getPositionInBank();
            } else {
                int index = start + i;
                String string = bottomMenu = index < pages.length ? pages[index] : "";
                if (bottomMenu.length() > 12) {
                    bottomMenu = bottomMenu.substring(0, 12);
                }
                isBottomMenuOn = index == page;
            }
            double[] bottomMenuColor = DAWColors.getColorEntry(color);
            IParameter param = cd.getFXParam(i);
            boolean exists = param.doesExist();
            String parameterName = exists ? param.getName(9) : "";
            int parameterValue = valueChanger.toDisplayValue(exists ? param.getValue() : 0);
            String parameterValueStr = exists ? param.getDisplayedValue(8) : "";
            boolean parameterIsActive = this.isKnobTouched[i];
            int parameterModulatedValue = valueChanger.toDisplayValue(exists ? param.getModulatedValue() : -1);
            message.addParameterElement(i != 5 || hasPinning ? MENU[i] : "", isTopMenuOn, bottomMenu, "", bottomMenuColor, isBottomMenuOn, parameterName, parameterValue, parameterValueStr, parameterIsActive, parameterModulatedValue);
        }
        display.send(message);
    }

    public boolean canSelectPreviousPage() {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        return this.showDevices ? cursorDevice.canSelectPreviousFX() : cursorDevice.hasPreviousParameterPage();
    }

    public boolean canSelectNextPage() {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        return this.showDevices ? cursorDevice.canSelectNextFX() : cursorDevice.hasNextParameterPage();
    }

    public void selectPreviousPage() {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (this.showDevices) {
            cursorDevice.selectPrevious();
        } else {
            cursorDevice.previousParameterPage();
        }
    }

    public void selectNextPage() {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (this.showDevices) {
            cursorDevice.selectNext();
        } else {
            cursorDevice.nextParameterPage();
        }
    }

    public void selectPreviousPageBank() {
        ICursorDevice cd = this.model.getCursorDevice();
        if (this.showDevices) {
            cd.selectPreviousBank();
        } else {
            cd.previousParameterPageBank();
        }
    }

    public void selectNextPageBank() {
        ICursorDevice cd = this.model.getCursorDevice();
        if (this.showDevices) {
            cd.selectNextBank();
        } else {
            cd.nextParameterPageBank();
        }
    }
}

