/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.device;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.device.DeviceLayerMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;

public class DeviceLayerModeVolume
extends DeviceLayerMode {
    public DeviceLayerModeVolume(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        int offset;
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel layer = cd.getLayerOrDrumPad((offset = DeviceLayerModeVolume.getDrumPadIndex(cd)) + index);
        if (layer.doesExist()) {
            cd.changeLayerOrDrumPadVolume(offset + index, value);
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        int offset;
        this.isKnobTouched[index] = isTouched;
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel layer = cd.getLayerOrDrumPad((offset = DeviceLayerModeVolume.getDrumPadIndex(cd)) + index);
        if (!layer.doesExist()) {
            return;
        }
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                cd.resetLayerOrDrumPadVolume(offset + index);
                return;
            }
            ((PushControlSurface)this.surface).getDisplay().notify("Volume: " + layer.getVolumeStr());
        }
        cd.touchLayerOrDrumPadVolume(layer.getIndex(), isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        ICursorDevice cd = this.model.getCursorDevice();
        int offset = DeviceLayerModeVolume.getDrumPadIndex(cd);
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        for (int i = 0; i < 8; ++i) {
            IChannel layer = cd.getLayerOrDrumPad(offset + i);
            d.setCell(0, i, layer.doesExist() ? "Volume" : "").setCell(1, i, layer.getVolumeStr(8));
            if (layer.doesExist()) {
                d.setCell(2, i, config.isEnableVUMeters() ? layer.getVu() : layer.getVolume(), Format.FORMAT_VALUE);
                continue;
            }
            d.clearCell(2, i);
        }
        d.done(0).done(1).done(2);
        this.drawRow4(d, cd);
    }

    @Override
    public void updateDisplayElements(DisplayMessage message, ICursorDevice cd, IChannel l) {
        this.updateChannelDisplay(message, cd, 1, true, false);
    }
}

