/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.device;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.mode.device.DeviceLayerMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.utils.Pair;

public class DeviceLayerModeSend
extends DeviceLayerMode {
    public DeviceLayerModeSend(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        int offset;
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel layer = cd.getLayerOrDrumPad((offset = DeviceLayerModeSend.getDrumPadIndex(cd)) + index);
        if (layer.doesExist()) {
            cd.changeLayerOrDrumPadSend(offset + index, this.getCurrentSendIndex(), value);
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        int offset;
        this.isKnobTouched[index] = isTouched;
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel layer = cd.getLayerOrDrumPad((offset = DeviceLayerModeSend.getDrumPadIndex(cd)) + index);
        if (!layer.doesExist()) {
            return;
        }
        int sendIndex = this.getCurrentSendIndex();
        if (isTouched) {
            String name;
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                cd.resetLayerOrDrumPadSend(offset + index, sendIndex);
                return;
            }
            IChannelBank fxTrackBank = this.model.getEffectTrackBank();
            String string = name = fxTrackBank == null ? layer.getSend(sendIndex).getName() : fxTrackBank.getTrack(sendIndex).getName();
            if (!name.isEmpty()) {
                ((PushControlSurface)this.surface).getDisplay().notify("Send " + name + ": " + layer.getSend(sendIndex).getDisplayedValue());
            }
        }
        cd.touchLayerOrDrumPadSend(offset + index, sendIndex, isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        ICursorDevice cd = this.model.getCursorDevice();
        int offset = DeviceLayerModeSend.getDrumPadIndex(cd);
        int sendIndex = this.getCurrentSendIndex();
        for (int i = 0; i < 8; ++i) {
            IChannel layer = cd.getLayerOrDrumPad(offset + i);
            boolean exists = layer.doesExist();
            ISend send = layer.getSend(sendIndex);
            d.setCell(0, i, exists ? send.getName() : "").setCell(1, i, send.getDisplayedValue(8));
            if (exists) {
                d.setCell(2, i, send.getValue(), Format.FORMAT_VALUE);
                continue;
            }
            d.clearCell(2, i);
        }
        d.done(0).done(1).done(2);
        this.drawRow4(d, cd);
    }

    @Override
    public void updateDisplayElements(DisplayMessage message, ICursorDevice cd, IChannel l) {
        int sendIndex = this.getCurrentSendIndex();
        IChannelBank fxTrackBank = this.model.getEffectTrackBank();
        this.updateMenuItems(5 + sendIndex % 4);
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        int offset = DeviceLayerModeSend.getDrumPadIndex(cd);
        int sendOffset = config.isSendsAreToggled() ? 4 : 0;
        for (int i = 0; i < 8; ++i) {
            IChannel layer = cd.getLayerOrDrumPad(offset + i);
            Pair pair = (Pair)this.menu.get(i);
            String topMenu = (String)pair.getKey();
            boolean isTopMenuOn = (Boolean)pair.getValue();
            String[] sendName = new String[4];
            String[] valueStr = new String[4];
            int[] value = new int[4];
            int[] modulatedValue = new int[4];
            boolean[] selected = new boolean[4];
            for (int j = 0; j < 4; ++j) {
                int sendPos = sendOffset + j;
                ISend send = layer.getSend(sendPos);
                sendName[j] = fxTrackBank == null ? send.getName() : fxTrackBank.getTrack(sendPos).getName();
                valueStr[j] = send.doesExist() && sendIndex == sendPos && this.isKnobTouched[i] ? send.getDisplayedValue() : "";
                value[j] = send.doesExist() ? send.getValue() : 0;
                modulatedValue[j] = send.doesExist() ? send.getModulatedValue() : 0;
                selected[j] = sendIndex == sendPos;
            }
            message.addSendsElement(topMenu, isTopMenuOn, layer.doesExist() ? layer.getName() : "", ChannelType.LAYER, cd.getLayerOrDrumPad(offset + i).getColor(), layer.isSelected(), sendName, valueStr, value, modulatedValue, selected, false);
        }
    }

    private int getCurrentSendIndex() {
        return ((PushControlSurface)this.surface).getModeManager().getActiveModeId() - Modes.MODE_DEVICE_LAYER_SEND1;
    }
}

