/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.device;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.device.DeviceLayerMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;

public class DeviceLayerModePan
extends DeviceLayerMode {
    public DeviceLayerModePan(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        int offset;
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel layer = cd.getLayerOrDrumPad((offset = DeviceLayerModePan.getDrumPadIndex(cd)) + index);
        if (layer.doesExist()) {
            cd.changeLayerOrDrumPadPan(offset + index, value);
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        int offset;
        this.isKnobTouched[index] = isTouched;
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel layer = cd.getLayerOrDrumPad((offset = DeviceLayerModePan.getDrumPadIndex(cd)) + index);
        if (!layer.doesExist()) {
            return;
        }
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                cd.resetLayerOrDrumPadPan(offset + index);
                return;
            }
            ((PushControlSurface)this.surface).getDisplay().notify("Pan: " + layer.getPanStr());
        }
        cd.touchLayerOrDrumPadPan(layer.getIndex(), isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        ICursorDevice cd = this.model.getCursorDevice();
        int offset = DeviceLayerModePan.getDrumPadIndex(cd);
        for (int i = 0; i < 8; ++i) {
            IChannel layer = cd.getLayerOrDrumPad(offset + i);
            d.setCell(0, i, layer.doesExist() ? "Pan" : "").setCell(1, i, layer.getPanStr(8));
            if (layer.doesExist()) {
                d.setCell(2, i, layer.getPan(), Format.FORMAT_VALUE);
                continue;
            }
            d.clearCell(2, i);
        }
        d.done(0).done(1).done(2);
        this.drawRow4(d, cd);
    }

    @Override
    public void updateDisplayElements(DisplayMessage message, ICursorDevice cd, IChannel l) {
        this.updateChannelDisplay(message, cd, 2, false, true);
    }
}

