/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.device;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.mode.device.DeviceParamsMode;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class DeviceLayerMode
extends BaseMode {
    protected final List<Pair<String, Boolean>> menu = new ArrayList<Pair<String, Boolean>>();

    public DeviceLayerMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
        for (int i = 0; i < 8; ++i) {
            this.menu.add(new Pair<String, Boolean>(" ", Boolean.FALSE));
        }
    }

    @Override
    public void onValueKnob(int index, int value) {
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel selectedDeviceLayer = cd.getSelectedLayerOrDrumPad();
        if (selectedDeviceLayer == null) {
            return;
        }
        switch (index) {
            case 0: {
                cd.changeLayerOrDrumPadVolume(selectedDeviceLayer.getIndex(), value);
                break;
            }
            case 1: {
                cd.changeLayerOrDrumPadPan(selectedDeviceLayer.getIndex(), value);
                break;
            }
            default: {
                if (this.isPush2 && index < 4) break;
                int sendIndex = index - (this.isPush2 ? (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isSendsAreToggled() ? 0 : 4) : 2);
                cd.changeLayerOrDrumPadSend(selectedDeviceLayer.getIndex(), sendIndex, value);
            }
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        int sendIndex;
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel l = cd.getSelectedLayerOrDrumPad();
        if (l == null) {
            return;
        }
        this.isKnobTouched[index] = isTouched;
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                switch (index) {
                    case 0: {
                        cd.resetLayerOrDrumPadVolume(l.getIndex());
                        break;
                    }
                    case 1: {
                        cd.resetLayerOrDrumPadPan(l.getIndex());
                        break;
                    }
                    default: {
                        if (this.isPush2 && index < 4) break;
                        int sendIndex2 = index - (this.isPush2 ? (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isSendsAreToggled() ? 0 : 4) : 2);
                        cd.resetLayerSend(l.getIndex(), sendIndex2);
                    }
                }
                return;
            }
            switch (index) {
                case 0: {
                    ((PushControlSurface)this.surface).getDisplay().notify("Volume: " + l.getVolumeStr());
                    break;
                }
                case 1: {
                    ((PushControlSurface)this.surface).getDisplay().notify("Pan: " + l.getPanStr());
                    break;
                }
                default: {
                    String name;
                    if (this.isPush2 && index < 4) break;
                    sendIndex = index - (this.isPush2 ? (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isSendsAreToggled() ? 0 : 4) : 2);
                    IChannelBank fxTrackBank = this.model.getEffectTrackBank();
                    String string = name = fxTrackBank == null ? l.getSend(sendIndex).getName() : fxTrackBank.getTrack(sendIndex).getName();
                    if (name.isEmpty()) break;
                    ((PushControlSurface)this.surface).getDisplay().notify("Send " + name + ": " + l.getSend(sendIndex).getDisplayedValue());
                }
            }
        }
        switch (index) {
            case 0: {
                cd.touchLayerOrDrumPadVolume(l.getIndex(), isTouched);
                break;
            }
            case 1: {
                cd.touchLayerOrDrumPadPan(l.getIndex(), isTouched);
                break;
            }
            default: {
                if (this.isPush2 && index < 4) break;
                sendIndex = index - (this.isPush2 ? (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isSendsAreToggled() ? 0 : 4) : 2);
                cd.touchLayerOrDrumPadSend(l.getIndex(), sendIndex, isTouched);
            }
        }
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            return;
        }
        if (event == ButtonEvent.UP) {
            ICursorDevice cd = this.model.getCursorDevice();
            if (!cd.hasSelectedDevice()) {
                return;
            }
            int offset = DeviceLayerMode.getDrumPadIndex(cd);
            IChannel layer = cd.getLayerOrDrumPad(offset + index);
            if (!layer.doesExist()) {
                return;
            }
            int layerIndex = layer.getIndex();
            if (!layer.isSelected()) {
                cd.selectLayerOrDrumPad(layerIndex);
                return;
            }
            cd.enterLayerOrDrumPad(layer.getIndex());
            cd.selectFirstDeviceInLayerOrDrumPad(layer.getIndex());
            ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
            modeManager.setActiveMode(Modes.MODE_DEVICE_PARAMS);
            ((DeviceParamsMode)modeManager.getMode(Modes.MODE_DEVICE_PARAMS)).setShowDevices(true);
            return;
        }
        ((PushControlSurface)this.surface).setButtonConsumed(20 + index);
        this.moveUp();
    }

    protected void moveUp() {
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.hasSelectedDevice()) {
            ((PushControlSurface)this.surface).getViewManager().getActiveView().executeTriggerCommand(Commands.COMMAND_TRACK, ButtonEvent.DOWN);
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        modeManager.setActiveMode(Modes.MODE_DEVICE_PARAMS);
        cd.selectChannel();
        ((DeviceParamsMode)modeManager.getMode(Modes.MODE_DEVICE_PARAMS)).setShowDevices(true);
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (!this.isPush2 || config.isMuteLongPressed() || config.isSoloLongPressed() || config.isMuteSoloLocked()) {
            ICursorDevice cd = this.model.getCursorDevice();
            int offset = DeviceLayerMode.getDrumPadIndex(cd);
            if (config.isMuteState()) {
                cd.toggleLayerOrDrumPadMute(offset + index);
            } else {
                cd.toggleLayerOrDrumPadSolo(offset + index);
            }
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        switch (index) {
            case 0: {
                if (modeManager.isActiveMode(Modes.MODE_DEVICE_LAYER_VOLUME)) {
                    modeManager.setActiveMode(Modes.MODE_DEVICE_LAYER);
                    break;
                }
                modeManager.setActiveMode(Modes.MODE_DEVICE_LAYER_VOLUME);
                break;
            }
            case 1: {
                if (modeManager.isActiveMode(Modes.MODE_DEVICE_LAYER_PAN)) {
                    modeManager.setActiveMode(Modes.MODE_DEVICE_LAYER);
                    break;
                }
                modeManager.setActiveMode(Modes.MODE_DEVICE_LAYER_PAN);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                IChannelBank fxTrackBank;
                if (this.model.isEffectTrackBankActive()) {
                    return;
                }
                if (!config.isSendsAreToggled() && !(fxTrackBank = this.model.getEffectTrackBank()).getTrack(4).doesExist()) {
                    return;
                }
                config.setSendsAreToggled(!config.isSendsAreToggled());
                if (modeManager.isActiveMode(Modes.MODE_DEVICE_LAYER)) break;
                modeManager.setActiveMode(Modes.MODE_DEVICE_LAYER_SEND1 + (config.isSendsAreToggled() ? 4 : 0));
                break;
            }
            case 7: {
                if (((PushControlSurface)this.surface).isShiftPressed()) {
                    this.handleSendEffect(config.isSendsAreToggled() ? 7 : 3);
                    break;
                }
                this.moveUp();
                break;
            }
            default: {
                this.handleSendEffect(index - (config.isSendsAreToggled() ? 0 : 4));
            }
        }
    }

    protected void handleSendEffect(int sendIndex) {
        ModeManager modeManager;
        if (this.model.isEffectTrackBankActive()) {
            return;
        }
        IChannelBank fxTrackBank = this.model.getEffectTrackBank();
        if (!fxTrackBank.getTrack(sendIndex).doesExist()) {
            return;
        }
        Integer si = Modes.MODE_DEVICE_LAYER_SEND1 + sendIndex;
        modeManager.setActiveMode((modeManager = ((PushControlSurface)this.surface).getModeManager()).isActiveMode(si) ? Modes.MODE_DEVICE_LAYER : si);
    }

    @Override
    public void updateDisplay1() {
        boolean noLayers;
        Display d = ((PushControlSurface)this.surface).getDisplay().clear();
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.hasSelectedDevice()) {
            d.setBlock(1, 0, "           Select").setBlock(1, 1, "a device or press").setBlock(1, 2, "'Add Effect'...  ").allDone();
            return;
        }
        boolean bl = noLayers = cd.hasLayers() && cd.hasZeroLayers();
        if (noLayers) {
            d.setBlock(1, 1, "    Please create").setBlock(1, 2, cd.hasDrumPads() ? "a Drum Pad..." : "a Device Layer...");
        } else {
            IChannel l = cd.getSelectedLayerOrDrumPad();
            if (l != null) {
                d.setCell(0, 0, "Volume").setCell(1, 0, l.getVolumeStr(8)).setCell(2, 0, ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isEnableVUMeters() ? l.getVu() : l.getVolume(), Format.FORMAT_VALUE);
                d.setCell(0, 1, "Pan").setCell(1, 1, l.getPanStr(8)).setCell(2, 1, l.getPan(), Format.FORMAT_PAN);
                IChannelBank fxTrackBank = this.model.getEffectTrackBank();
                if (fxTrackBank == null) {
                    for (int i = 0; i < 6; ++i) {
                        int pos = 2 + i;
                        ISend send = l.getSend(i);
                        d.setCell(0, pos, send.getName()).setCell(1, pos, send.getDisplayedValue(8)).setCell(2, pos, send.getValue(), Format.FORMAT_VALUE);
                    }
                } else {
                    boolean isFX = this.model.isEffectTrackBankActive();
                    for (int i = 0; i < 6; ++i) {
                        ITrack fxTrack = fxTrackBank.getTrack(i);
                        boolean isEmpty = isFX || !fxTrack.doesExist();
                        int pos = 2 + i;
                        if (isEmpty) {
                            d.clearCell(0, pos);
                            d.clearCell(2, pos);
                            continue;
                        }
                        ISend send = l.getSend(i);
                        d.setCell(0, pos, fxTrack.getName()).setCell(1, pos, send.getDisplayedValue(8));
                        d.setCell(2, pos, send.getValue(), Format.FORMAT_VALUE);
                    }
                }
            }
        }
        this.drawRow4(d, cd);
    }

    @Override
    public void updateDisplay2() {
        boolean noLayers;
        ICursorDevice cd = this.model.getCursorDevice();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        if (!cd.hasSelectedDevice()) {
            for (int i = 0; i < 8; ++i) {
                message.addOptionElement(i == 2 ? "Please select a device or press 'Add Device'..." : "", i == 7 ? "Up" : "", true, "", "", false, true);
            }
            display.send(message);
            return;
        }
        boolean bl = noLayers = cd.hasLayers() && cd.hasZeroLayers();
        if (noLayers) {
            for (int i = 0; i < 8; ++i) {
                message.addOptionElement(i == 3 ? "Please create a " + (cd.hasDrumPads() ? "Drum Pad..." : "Device Layer...") : "", i == 7 ? "Up" : "", true, "", "", false, true);
            }
            display.send(message);
            return;
        }
        this.updateDisplayElements(message, cd, cd.getSelectedLayerOrDrumPad());
        display.send(message);
    }

    protected void updateDisplayElements(DisplayMessage message, ICursorDevice cd, IChannel l) {
        int sendsIndex;
        int offset = DeviceLayerMode.getDrumPadIndex(cd);
        int n = sendsIndex = l == null ? -1 : l.getIndex() - offset + 1;
        if (sendsIndex == 8) {
            sendsIndex = 6;
        }
        this.updateMenuItems(-1);
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        for (int i = 0; i < 8; ++i) {
            IChannel layer = cd.getLayerOrDrumPad(offset + i);
            Pair<String, Boolean> pair = this.menu.get(i);
            String topMenu = pair.getKey();
            boolean isTopMenuOn = pair.getValue();
            String bottomMenu = layer.doesExist() ? layer.getName(12) : "";
            double[] bottomMenuColor = layer.getColor();
            boolean isBottomMenuOn = layer.isSelected();
            if (layer.isSelected()) {
                IValueChanger valueChanger = this.model.getValueChanger();
                message.addChannelElement(topMenu, isTopMenuOn, bottomMenu, ChannelType.LAYER, bottomMenuColor, isBottomMenuOn, valueChanger.toDisplayValue(layer.getVolume()), valueChanger.toDisplayValue(layer.getModulatedVolume()), this.isKnobTouched[0] ? layer.getVolumeStr(8) : "", valueChanger.toDisplayValue(layer.getPan()), valueChanger.toDisplayValue(layer.getModulatedPan()), this.isKnobTouched[1] ? layer.getPanStr(8) : "", valueChanger.toDisplayValue(config.isEnableVUMeters() ? layer.getVu() : 0), layer.isMute(), layer.isSolo(), false, 0);
                continue;
            }
            if (sendsIndex == i && l != null) {
                IChannelBank fxTrackBank = this.model.getEffectTrackBank();
                String[] sendName = new String[4];
                String[] valueStr = new String[4];
                int[] value = new int[4];
                int[] modulatedValue = new int[4];
                boolean[] selected = new boolean[4];
                for (int j = 0; j < 4; ++j) {
                    int sendOffset = config.isSendsAreToggled() ? 4 : 0;
                    int sendPos = sendOffset + j;
                    ISend send = l.getSend(sendPos);
                    sendName[j] = fxTrackBank == null ? send.getName() : fxTrackBank.getTrack(sendPos).getName();
                    boolean doesExist = send.doesExist();
                    valueStr[j] = doesExist && this.isKnobTouched[4 + j] ? send.getDisplayedValue() : "";
                    value[j] = doesExist ? send.getValue() : 0;
                    modulatedValue[j] = doesExist ? send.getModulatedValue() : 0;
                    selected[j] = true;
                }
                message.addSendsElement(topMenu, isTopMenuOn, layer.doesExist() ? layer.getName() : "", ChannelType.LAYER, cd.getLayerOrDrumPad(offset + i).getColor(), layer.isSelected(), sendName, valueStr, value, modulatedValue, selected, true);
                continue;
            }
            message.addChannelSelectorElement(topMenu, isTopMenuOn, bottomMenu, ChannelType.LAYER, bottomMenuColor, isBottomMenuOn);
        }
    }

    protected void updateChannelDisplay(DisplayMessage message, ICursorDevice cd, int selectedMenu, boolean isVolume, boolean isPan) {
        this.updateMenuItems(selectedMenu);
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        int offset = DeviceLayerMode.getDrumPadIndex(cd);
        IValueChanger valueChanger = this.model.getValueChanger();
        for (int i = 0; i < 8; ++i) {
            IChannel layer = cd.getLayerOrDrumPad(offset + i);
            Pair<String, Boolean> pair = this.menu.get(i);
            String topMenu = pair.getKey();
            boolean isTopMenuOn = pair.getValue();
            message.addChannelElement(selectedMenu, topMenu, isTopMenuOn, layer.doesExist() ? layer.getName() : "", ChannelType.LAYER, cd.getLayerOrDrumPad(offset + i).getColor(), layer.isSelected(), valueChanger.toDisplayValue(layer.getVolume()), valueChanger.toDisplayValue(layer.getModulatedVolume()), isVolume && this.isKnobTouched[i] ? layer.getVolumeStr(8) : "", valueChanger.toDisplayValue(layer.getPan()), valueChanger.toDisplayValue(layer.getModulatedPan()), isPan && this.isKnobTouched[i] ? layer.getPanStr() : "", valueChanger.toDisplayValue(config.isEnableVUMeters() ? layer.getVu() : 0), layer.isMute(), layer.isSolo(), false, 0);
        }
    }

    protected void updateMenuItems(int selectedMenu) {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (config.isMuteLongPressed() || config.isMuteSoloLocked() && config.isMuteState()) {
            this.updateMuteMenu();
        } else if (config.isSoloLongPressed() || config.isMuteSoloLocked() && config.isSoloState()) {
            this.updateSoloMenu();
        } else {
            this.updateLayerMenu(selectedMenu);
        }
    }

    protected void updateSoloMenu() {
        ICursorDevice cd = this.model.getCursorDevice();
        for (int i = 0; i < 8; ++i) {
            IChannel layer;
            this.menu.get(i).set((layer = cd.getLayerOrDrumPad(i)).doesExist() ? "Solo" : "", layer.isSolo());
        }
    }

    protected void updateMuteMenu() {
        ICursorDevice cd = this.model.getCursorDevice();
        for (int i = 0; i < 8; ++i) {
            IChannel layer;
            this.menu.get(i).set((layer = cd.getLayerOrDrumPad(i)).doesExist() ? "Mute" : "", layer.isMute());
        }
    }

    protected void updateLayerMenu(int selectedMenu) {
        boolean sendsAreToggled;
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        this.menu.get(0).set("Volume", selectedMenu - 1 == 0);
        this.menu.get(1).set("Pan", selectedMenu - 1 == 1);
        this.menu.get(2).set(" ", Boolean.FALSE);
        if (this.model.isEffectTrackBankActive()) {
            for (int i = 3; i < 7; ++i) {
                this.menu.get(i).set(" ", Boolean.FALSE);
            }
            return;
        }
        this.menu.get(3).set((sendsAreToggled = config.isSendsAreToggled()) ? "Sends 5-8" : "Sends 1-4", sendsAreToggled);
        IChannelBank tb = this.model.getCurrentTrackBank();
        int sendOffset = sendsAreToggled ? 4 : 0;
        boolean isShiftPressed = ((PushControlSurface)this.surface).isShiftPressed();
        for (int i = 0; i < (isShiftPressed ? 4 : 3); ++i) {
            String sendName;
            this.menu.get(4 + i).set((sendName = tb.getEditSendName(sendOffset + i)).isEmpty() ? " " : sendName, 4 + i == selectedMenu - 1);
        }
        if (!isShiftPressed) {
            this.menu.get(7).set("Up", Boolean.TRUE);
        }
    }

    @Override
    public void updateFirstRow() {
        ICursorDevice cd = this.model.getCursorDevice();
        if (cd == null || !cd.hasLayers()) {
            this.disableFirstRow();
            return;
        }
        int offset = DeviceLayerMode.getDrumPadIndex(cd);
        for (int i = 0; i < 8; ++i) {
            IChannel dl = cd.getLayerOrDrumPad(offset + i);
            ((PushControlSurface)this.surface).updateButton(20 + i, dl.doesExist() && dl.isActivated() ? (dl.isSelected() ? (this.isPush2 ? 6 : 10) : (this.isPush2 ? 75 : 13)) : (this.isPush2 ? 0 : 0));
        }
    }

    @Override
    public void updateSecondRow() {
        ICursorDevice cd = this.model.getCursorDevice();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        boolean muteState = config.isMuteState();
        if (this.isPush2) {
            if (config.isMuteLongPressed() || config.isSoloLongPressed() || config.isMuteSoloLocked()) {
                int offset = DeviceLayerMode.getDrumPadIndex(cd);
                for (int i = 0; i < 8; ++i) {
                    IChannel layer = cd.getLayerOrDrumPad(offset + i);
                    int color = 0;
                    if (layer.doesExist()) {
                        if (muteState) {
                            if (layer.isMute()) {
                                color = 70;
                            }
                        } else if (layer.isSolo()) {
                            color = 7;
                        }
                    }
                    ((PushControlSurface)this.surface).updateButton(102 + i, color);
                }
                return;
            }
            ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
            ((PushControlSurface)this.surface).updateButton(102, modeManager.isActiveMode(Modes.MODE_DEVICE_LAYER_VOLUME) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(103, modeManager.isActiveMode(Modes.MODE_DEVICE_LAYER_PAN) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(104, 0);
            ((PushControlSurface)this.surface).updateButton(105, 0);
            ((PushControlSurface)this.surface).updateButton(106, modeManager.isActiveMode(config.isSendsAreToggled() ? Modes.MODE_DEVICE_LAYER_SEND5 : Modes.MODE_DEVICE_LAYER_SEND1) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(107, modeManager.isActiveMode(config.isSendsAreToggled() ? Modes.MODE_DEVICE_LAYER_SEND6 : Modes.MODE_DEVICE_LAYER_SEND2) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(108, modeManager.isActiveMode(config.isSendsAreToggled() ? Modes.MODE_DEVICE_LAYER_SEND7 : Modes.MODE_DEVICE_LAYER_SEND3) ? 120 : 0);
            ((PushControlSurface)this.surface).updateButton(109, modeManager.isActiveMode(config.isSendsAreToggled() ? Modes.MODE_DEVICE_LAYER_SEND8 : Modes.MODE_DEVICE_LAYER_SEND4) ? 120 : 0);
            return;
        }
        if (cd == null || !cd.hasLayers()) {
            this.disableSecondRow();
            ((PushControlSurface)this.surface).updateButton(109, this.isPush2 ? 120 : 3);
            return;
        }
        int offset = DeviceLayerMode.getDrumPadIndex(cd);
        for (int i = 0; i < 8; ++i) {
            IChannel dl = cd.getLayerOrDrumPad(offset + i);
            int color = 0;
            if (dl.doesExist()) {
                if (muteState) {
                    if (!dl.isMute()) {
                        color = 13;
                    }
                } else {
                    color = dl.isSolo() ? 45 : 1;
                }
            }
            ((PushControlSurface)this.surface).updateButton(102 + i, color);
        }
    }

    protected void drawRow4(Display d, ICursorDevice cd) {
        int offset = DeviceLayerMode.getDrumPadIndex(cd);
        for (int i = 0; i < 8; ++i) {
            IChannel layer = cd.getLayerOrDrumPad(offset + i);
            String n = StringUtils.shortenAndFixASCII(layer.getName(), layer.isSelected() ? 7 : 8);
            d.setCell(3, i, layer.isSelected() ? PushDisplay.RIGHT_ARROW + n : n);
        }
        d.allDone();
    }

    protected static int getDrumPadIndex(ICursorDevice cd) {
        IChannel selectedDrumPad;
        if (cd.hasDrumPads() && (selectedDrumPad = cd.getSelectedDrumPad()) != null && selectedDrumPad.getIndex() > 7) {
            return 8;
        }
        return 0;
    }
}

