/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode.device;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class DeviceBrowserMode
extends BaseMode {
    private static final int SELECTION_OFF = 0;
    private static final int SELECTION_PRESET = 1;
    private static final int SELECTION_FILTER = 2;
    private int selectionMode;
    private int filterColumn;

    public DeviceBrowserMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
        this.selectionMode = 0;
        this.filterColumn = -1;
    }

    @Override
    public void onDeactivate() {
        this.model.getBrowser().stopBrowsing(true);
    }

    public void changeSelectedColumnValue(int value) {
        int index = this.filterColumn == -1 ? 7 : this.filterColumn;
        this.changeValue(index, value);
    }

    public void resetFilterColumn() {
        this.filterColumn = -1;
    }

    @Override
    public void onValueKnob(int index, int value) {
        if (!this.isKnobTouched[index]) {
            return;
        }
        if (this.increaseKnobMovement()) {
            this.changeValue(index, value);
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        for (int i = 0; i < this.isKnobTouched.length; ++i) {
            if (!this.isKnobTouched[i] || i == index) continue;
            return;
        }
        this.isKnobTouched[index] = isTouched;
        if (isTouched) {
            if (((PushControlSurface)this.surface).isDeletePressed()) {
                ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
                IBrowserColumn fc = this.getFilterColumn(index);
                if (fc != null && fc.doesExist()) {
                    this.model.getBrowser().resetFilterColumn(fc.getIndex());
                }
                return;
            }
        } else {
            this.selectionMode = 0;
            return;
        }
        if (index == 7) {
            this.selectionMode = 1;
            this.filterColumn = -1;
        } else {
            IBrowserColumn fc = this.getFilterColumn(index);
            if (fc != null && fc.doesExist()) {
                this.selectionMode = 2;
                this.filterColumn = fc.getIndex();
            }
        }
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.isPush2) {
            this.selectNext(index, 1);
        } else {
            this.selectPrevious(index, 1);
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.isPush2) {
            this.selectPrevious(index, 1);
        } else {
            this.selectNext(index, 1);
        }
    }

    @Override
    public void updateDisplay1() {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            ((PushControlSurface)this.surface).getModeManager().restoreMode();
            return;
        }
        Display d = ((PushControlSurface)this.surface).getDisplay().clear();
        switch (this.selectionMode) {
            case 0: {
                String selectedResult = browser.getSelectedResult();
                String deviceName = this.model.getCursorDevice().getName();
                String selectedContentType = browser.getSelectedContentType();
                if (this.filterColumn == -1) {
                    selectedContentType = PushDisplay.RIGHT_ARROW + selectedContentType;
                }
                d.setCell(0, 7, selectedContentType).setBlock(3, 0, " Selected Device:").setBlock(3, 1, deviceName.length() == 0 ? "None" : deviceName);
                boolean isPresetSession = browser.isPresetContentType();
                d.setBlock(3, 2, isPresetSession ? " Selected Preset:" : "").setBlock(3, 3, isPresetSession ? (selectedResult == null || selectedResult.length() == 0 ? "None" : selectedResult) : "");
                for (int i = 0; i < 7; ++i) {
                    String name;
                    IBrowserColumn column = this.getFilterColumn(i);
                    String string = name = column == null ? "" : StringUtils.shortenAndFixASCII(column.getName(), 8);
                    if (i == this.filterColumn) {
                        name = PushDisplay.RIGHT_ARROW + name;
                    }
                    d.setCell(0, i, name).setCell(1, i, DeviceBrowserMode.getColumnName(column));
                }
                break;
            }
            case 1: {
                IBrowserColumnItem[] results = browser.getResultColumnItems();
                if (!results[0].doesExist()) {
                    d.clear().setBlock(1, 1, "       No results").setBlock(1, 2, "available...").allDone();
                    return;
                }
                for (int i = 0; i < 16; ++i) {
                    if (i < results.length) {
                        d.setBlock(i % 4, i / 4, (results[i].isSelected() ? PushDisplay.RIGHT_ARROW : " ") + results[i].getName(16));
                        continue;
                    }
                    d.setBlock(i % 4, i / 4, "");
                }
                break;
            }
            case 2: {
                IBrowserColumnItem[] items = browser.getFilterColumn(this.filterColumn).getItems();
                for (int i = 0; i < 16; ++i) {
                    String text = (items[i].isSelected() ? PushDisplay.RIGHT_ARROW : " ") + items[i].getName() + "                ";
                    if (!items[i].getName().isEmpty()) {
                        String hitStr = "(" + items[i].getHitCount() + ")";
                        text = text.substring(0, 17 - hitStr.length()) + hitStr;
                    }
                    d.setBlock(i % 4, i / 4, text);
                }
                break;
            }
        }
        d.allDone();
    }

    @Override
    public void updateDisplay2() {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            ((PushControlSurface)this.surface).getModeManager().restoreMode();
            return;
        }
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        switch (this.selectionMode) {
            case 0: {
                String selectedResult = browser.getSelectedResult();
                if (selectedResult == null || selectedResult.length() == 0) {
                    selectedResult = "None";
                }
                boolean isPresetSession = browser.isPresetContentType();
                String deviceName = this.model.getCursorDevice().getName();
                for (int i = 0; i < 7; ++i) {
                    IBrowserColumn column = this.getFilterColumn(i);
                    String headerTopName = i == 0 ? "Device: " + (deviceName.isEmpty() ? "None" : deviceName) : "";
                    String headerBottomName = i == 0 && isPresetSession ? "Preset: " + selectedResult : "";
                    String menuBottomName = DeviceBrowserMode.getColumnName(column);
                    message.addOptionElement(headerTopName, column == null ? "" : column.getName(), i == this.filterColumn, headerBottomName, menuBottomName, !menuBottomName.equals(" "), false);
                }
                message.addOptionElement("", browser.getSelectedContentType(), this.filterColumn == -1, "", "", false, false);
                break;
            }
            case 1: {
                IBrowserColumnItem[] results = browser.getResultColumnItems();
                if (!results[0].doesExist()) {
                    for (int i = 0; i < 8; ++i) {
                        message.addOptionElement(i == 3 ? "No results available..." : "", "", false, "", "", false, false);
                    }
                    display.send(message);
                    return;
                }
                for (int i = 0; i < 8; ++i) {
                    String[] items = new String[6];
                    boolean[] selected = new boolean[6];
                    for (int item = 0; item < 6; ++item) {
                        int pos = i * 6 + item;
                        items[item] = pos < results.length ? results[pos].getName(16) : "";
                        selected[item] = pos < results.length ? results[pos].isSelected() : false;
                    }
                    message.addListElement(items, selected);
                }
                break;
            }
            case 2: {
                IBrowserColumnItem[] item = browser.getFilterColumn(this.filterColumn).getItems();
                for (int i = 0; i < 8; ++i) {
                    String[] items = new String[6];
                    boolean[] selected = new boolean[6];
                    for (int itemIndex = 0; itemIndex < 6; ++itemIndex) {
                        int pos = i * 6 + itemIndex;
                        String text = StringUtils.optimizeName(item[pos].getName(), 10);
                        if (!text.isEmpty()) {
                            text = text + " (" + item[pos].getHitCount() + ")";
                        }
                        items[itemIndex] = text;
                        selected[itemIndex] = item[pos].isSelected();
                    }
                    message.addListElement(items, selected);
                }
                break;
            }
        }
        display.send(message);
    }

    @Override
    public void updateFirstRow() {
        for (int i = 0; i < 7; ++i) {
            IBrowserColumn col = this.getFilterColumn(i);
            ((PushControlSurface)this.surface).updateButton(20 + i, col != null && col.doesExist() ? "BUTTON_COLOR_ON" : "BUTTON_COLOR_OFF");
        }
        ((PushControlSurface)this.surface).updateButton(27, "BUTTON_COLOR_ON");
    }

    @Override
    public void updateSecondRow() {
        for (int i = 0; i < 7; ++i) {
            IBrowserColumn col = this.getFilterColumn(i);
            ((PushControlSurface)this.surface).updateButton(102 + i, col != null && col.doesExist() ? "BUTTON_COLOR2_ON" : "BUTTON_COLOR_OFF");
        }
        ((PushControlSurface)this.surface).updateButton(109, "BUTTON_COLOR2_ON");
    }

    private IBrowserColumn getFilterColumn(int index) {
        IBrowser browser = this.model.getBrowser();
        int column = -1;
        boolean[] browserDisplayFilter = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getBrowserDisplayFilter();
        for (int i = 0; i < browser.getFilterColumnCount(); ++i) {
            if (!browserDisplayFilter[i] || ++column != index) continue;
            return browser.getFilterColumn(i);
        }
        return null;
    }

    private void selectNext(int index, int count) {
        block3: {
            IBrowser browser;
            block2: {
                browser = this.model.getBrowser();
                if (index >= 7) break block2;
                IBrowserColumn fc = this.getFilterColumn(index);
                if (fc == null || !fc.doesExist()) break block3;
                this.filterColumn = fc.getIndex();
                for (int i = 0; i < count; ++i) {
                    browser.selectNextFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) break block3;
                browser.nextFilterItemPage(this.filterColumn);
                break block3;
            }
            for (int i = 0; i < count; ++i) {
                browser.selectNextResult();
            }
        }
    }

    private void selectPrevious(int index, int count) {
        IBrowser browser = this.model.getBrowser();
        for (int i = 0; i < count; ++i) {
            if (index < 7) {
                IBrowserColumn fc = this.getFilterColumn(index);
                if (fc == null || !fc.doesExist()) continue;
                this.filterColumn = fc.getIndex();
                for (int j = 0; j < count; ++j) {
                    browser.selectPreviousFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) continue;
                browser.previousFilterItemPage(this.filterColumn);
                continue;
            }
            for (int j = 0; j < count; ++j) {
                browser.selectPreviousResult();
            }
        }
    }

    private void changeValue(int index, int value) {
        boolean direction;
        int speed = (int)this.model.getValueChanger().calcKnobSpeed(value, 1.0);
        boolean bl = direction = speed > 0;
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            speed *= 4;
        }
        speed = Math.abs(speed);
        if (direction) {
            this.selectNext(index, speed);
        } else {
            this.selectPrevious(index, speed);
        }
    }

    private static String getColumnName(IBrowserColumn column) {
        if (column == null || !column.doesCursorExist()) {
            return "";
        }
        return column.getCursorName().equals(column.getWildcard()) ? " " : column.getCursorName(12);
    }
}

