/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TransportMode
extends BaseMode {
    private static final int MIN_TEMPO = 20;
    private static final int MAX_TEMPO = 666;

    public TransportMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index == 0) {
            this.model.getTransport().setPreroll("none");
        } else if (index == 1) {
            this.model.getTransport().setPreroll("one_bar");
        } else if (index == 2) {
            this.model.getTransport().setPreroll("two_bars");
        } else if (index == 3) {
            this.model.getTransport().setPreroll("four_bars");
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index == 0) {
            this.model.getTransport().togglePrerollMetronome();
        }
    }

    @Override
    public void updateFirstRow() {
        ITransport transport = this.model.getTransport();
        String preroll = transport.getPreroll();
        ((PushControlSurface)this.surface).updateButton(20, "none".equals(preroll) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
        ((PushControlSurface)this.surface).updateButton(21, "one_bar".equals(preroll) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
        ((PushControlSurface)this.surface).updateButton(22, "two_bars".equals(preroll) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
        ((PushControlSurface)this.surface).updateButton(23, "four_bars".equals(preroll) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
        ((PushControlSurface)this.surface).updateButton(24, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(25, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(26, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(27, "BUTTON_COLOR_OFF");
    }

    @Override
    public void updateSecondRow() {
        ITransport transport = this.model.getTransport();
        ((PushControlSurface)this.surface).updateButton(102, transport.isPrerollMetronomeEnabled() ? "BUTTON_COLOR2_HI" : "BUTTON_COLOR_ON");
        ((PushControlSurface)this.surface).updateButton(103, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(104, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(105, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(106, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(107, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(108, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(109, "BUTTON_COLOR_OFF");
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        ITransport transport = this.model.getTransport();
        String preroll = transport.getPreroll();
        double tempo = transport.getTempo();
        d.clear();
        d.setBlock(2, 0, "Pre-roll");
        d.setCell(3, 0, (preroll == "none" ? PushDisplay.RIGHT_ARROW : " ") + "None");
        d.setCell(3, 1, (preroll == "one_bar" ? PushDisplay.RIGHT_ARROW : " ") + "1 Bar");
        d.setCell(3, 2, (preroll == "two_bars" ? PushDisplay.RIGHT_ARROW : " ") + "2 Bars");
        d.setCell(3, 3, (preroll == "four_bars" ? PushDisplay.RIGHT_ARROW : " ") + "4 Bars");
        d.setBlock(0, 0, "Play Metro during").setBlock(0, 1, "Pre-roll?");
        d.setCell(1, 0, transport.isPrerollMetronomeEnabled() ? " Yes" : " No");
        d.setCell(0, 4, "Tempo").setCell(1, 4, transport.formatTempo(tempo)).setCell(2, 4, TransportMode.formatTempoBars(tempo));
        d.setCell(0, 5, "Time Sig.").setCell(1, 5, transport.getNumerator() + " / " + transport.getDenominator());
        d.setBlock(0, 3, "Play Position").setBlock(1, 3, transport.getPositionText()).allDone();
    }

    @Override
    public void updateDisplay2() {
        ITransport transport = this.model.getTransport();
        String preroll = transport.getPreroll();
        double tempo = transport.getTempo();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        message.addOptionElement("Play Metronome during Pre-Roll?", transport.isPrerollMetronomeEnabled() ? "Yes" : "No", transport.isPrerollMetronomeEnabled(), "Pre-roll", "None", preroll == "none", false);
        message.addOptionElement("", "", false, "", "1 Bar", preroll == "one_bar", false);
        message.addOptionElement("", "", false, "", "2 Bars", preroll == "two_bars", false);
        message.addOptionElement("", "", false, "", "4 Bars", preroll == "four_bars", false);
        message.addParameterElement("Tempo", (int)this.convertTempo(tempo), transport.formatTempo(tempo), this.isKnobTouched[0], -1);
        message.addOptionElement("  Time Sig.", "", false, "       " + transport.getNumerator() + " / " + transport.getDenominator(), "", false, false);
        message.addOptionElement("        Play Position", "", false, "        " + transport.getPositionText(), "", false, false);
        message.addOptionElement("", "", false, "", "", false, false);
        display.send(message);
    }

    private static String formatTempoBars(double value) {
        double v = value - 20.0;
        int noOfBars = (int)Math.round(16.0 * v / 646.0);
        StringBuilder n = new StringBuilder();
        for (int j = 0; j < noOfBars / 2; ++j) {
            n.append(PushDisplay.BARS_TWO);
        }
        if (noOfBars % 2 == 1) {
            n.append(PushDisplay.BARS_ONE);
        }
        return PushDisplay.pad(n.toString(), 8, PushDisplay.BARS_NON);
    }

    private double convertTempo(double value) {
        double v = value - 20.0;
        return v * (double)(this.model.getValueChanger().getUpperBound() - 1) / 646.0;
    }
}

