/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class SetupMode
extends BaseMode {
    public SetupMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void onValueKnob(int index, int value) {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 2: {
                config.changeDisplayBrightness(value);
                break;
            }
            case 3: {
                config.changeLEDBrightness(value);
                break;
            }
            case 5: {
                config.changePadSensitivity(value);
                break;
            }
            case 6: {
                config.changePadGain(value);
                break;
            }
            case 7: {
                config.changePadDynamics(value);
                break;
            }
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
    }

    @Override
    public void updateSecondRow() {
        ((PushControlSurface)this.surface).updateButton(102, "BUTTON_COLOR_HI");
        ((PushControlSurface)this.surface).updateButton(103, "BUTTON_COLOR_ON");
        for (int i = 2; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(102 + i, "BUTTON_COLOR_OFF");
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index == 1) {
            ((PushControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_INFO);
        }
    }

    @Override
    public void updateDisplay1() {
    }

    @Override
    public void updateDisplay2() {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        message.addOptionElement("", "Setup", true, "", "", false, true);
        message.addOptionElement("Brightness", "Info", false, "", "", false, true);
        message.addParameterElement("Display", config.getDisplayBrightness() * 1023 / 100, config.getDisplayBrightness() + "%", this.isKnobTouched[2], -1);
        message.addParameterElement("LEDs", config.getLedBrightness() * 1023 / 100, config.getLedBrightness() + "%", this.isKnobTouched[3], -1);
        message.addOptionElement("        Pads", "", false, "", "", false, false);
        message.addParameterElement("Sensitivity", config.getPadSensitivity() * 1023 / 10, Integer.toString(config.getPadSensitivity()), this.isKnobTouched[5], -1);
        message.addParameterElement("Gain", config.getPadGain() * 1023 / 10, Integer.toString(config.getPadGain()), this.isKnobTouched[6], -1);
        message.addParameterElement("Dynamics", config.getPadDynamics() * 1023 / 10, Integer.toString(config.getPadDynamics()), this.isKnobTouched[7], -1);
        display.send(message);
    }
}

