/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ViewManager;

public class SessionViewSelectMode
extends BaseMode {
    private static final Integer[] VIEWS = new Integer[]{Views.VIEW_SESSION, Views.VIEW_SESSION, Views.VIEW_SCENE_PLAY, null, null, null, null, null};
    private static final String[] VIEW_NAMES = new String[]{"Session", "Flipped", "Scenes", "", "", "", "", ""};

    public SessionViewSelectMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index < 2) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).setFlipSession(index == 1);
        }
        this.activateView(VIEWS[index]);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        d.clear().setBlock(1, 0, "Session view:");
        for (int i = 0; i < VIEWS.length; ++i) {
            if (VIEWS[i] == null) continue;
            d.setCell(3, i, (this.isSelected(viewManager, i) ? PushDisplay.RIGHT_ARROW : "") + VIEW_NAMES[i]);
        }
        d.allDone();
    }

    @Override
    public void updateDisplay2() {
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        for (int i = 0; i < VIEWS.length; ++i) {
            boolean isMenuBottomSelected = VIEWS[i] != null && this.isSelected(viewManager, i);
            message.addOptionElement("", "", false, i == 0 ? "Session view" : "", VIEW_NAMES[i], isMenuBottomSelected, false);
        }
        display.send(message);
    }

    @Override
    public void updateFirstRow() {
        ColorManager colorManager = this.model.getColorManager();
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, colorManager.getColor(VIEWS[i] == null ? "BUTTON_COLOR_OFF" : (this.isSelected(viewManager, i) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON")));
        }
    }

    private void activateView(Integer viewID) {
        if (viewID == null) {
            return;
        }
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        viewManager.setActiveView(viewID);
        ((PushControlSurface)this.surface).getModeManager().restoreMode();
    }

    private boolean isSelected(ViewManager viewManager, int index) {
        boolean activeView = viewManager.isActiveView(VIEWS[index]);
        switch (index) {
            case 0: {
                return activeView && !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isFlipSession();
            }
            case 1: {
                return activeView && ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isFlipSession();
            }
        }
        return activeView;
    }
}

