/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ISceneBank;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;

public class SessionMode
extends BaseMode {
    private static final double[] BLACK = new double[]{0.0, 0.0, 0.0};
    private RowDisplayMode rowDisplayMode;
    private ITrackBank trackBank;

    public SessionMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
        this.rowDisplayMode = this.isPush2 ? RowDisplayMode.ALL : RowDisplayMode.UPPER;
        this.trackBank = model.createSceneViewTrackBank(8, 64);
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
    }

    @Override
    public void onValueKnob(int index, int value) {
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.isPush2) {
            if (index == 0) {
                this.rowDisplayMode = this.rowDisplayMode == RowDisplayMode.ALL || this.rowDisplayMode == RowDisplayMode.LOWER ? RowDisplayMode.UPPER : RowDisplayMode.ALL;
            } else if (index == 1) {
                this.rowDisplayMode = this.rowDisplayMode == RowDisplayMode.ALL || this.rowDisplayMode == RowDisplayMode.UPPER ? RowDisplayMode.LOWER : RowDisplayMode.ALL;
            }
        } else {
            this.rowDisplayMode = this.rowDisplayMode == RowDisplayMode.UPPER ? RowDisplayMode.LOWER : RowDisplayMode.UPPER;
        }
    }

    @Override
    public void updateFirstRow() {
        ColorManager colorManager = this.model.getColorManager();
        ((PushControlSurface)this.surface).updateButton(20, colorManager.getColor(this.rowDisplayMode == RowDisplayMode.UPPER ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON"));
        ((PushControlSurface)this.surface).updateButton(21, colorManager.getColor(this.rowDisplayMode == RowDisplayMode.LOWER ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON"));
        for (int i = 2; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, colorManager.getColor("BUTTON_COLOR_OFF"));
        }
    }

    @Override
    public void updateDisplay1() {
        if (((PushControlSurface)this.surface).getViewManager().isActiveView(Views.VIEW_SESSION)) {
            this.updateDisplay1Clips();
        } else {
            this.updateDisplay1Scenes();
        }
    }

    @Override
    public void updateDisplay2() {
        if (((PushControlSurface)this.surface).getViewManager().isActiveView(Views.VIEW_SESSION)) {
            this.updateDisplay2Clips();
        } else {
            this.updateDisplay2Scenes();
        }
    }

    private void updateDisplay1Scenes() {
        ISceneBank sceneBank = this.trackBank.getSceneBank();
        int maxCols = 8;
        int maxRows = this.rowDisplayMode == RowDisplayMode.ALL ? 8 : 4;
        Display d = ((PushControlSurface)this.surface).getDisplay().clear();
        for (int col = 0; col < 8; ++col) {
            for (int row = 0; row < maxRows; ++row) {
                IScene scene;
                int sceneIndex = (maxRows - 1 - row) * 8 + col;
                if (this.rowDisplayMode == RowDisplayMode.LOWER) {
                    sceneIndex += 32;
                }
                if (!(scene = sceneBank.getScene(sceneIndex)).doesExist()) continue;
                d.setCell(row, col, StringUtils.shortenAndFixASCII(scene.getName(8), 8));
            }
        }
        d.allDone();
    }

    private void updateDisplay1Clips() {
        int maxRows;
        IChannelBank tb = this.model.getCurrentTrackBank();
        boolean flipSession = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isFlipSession();
        int numTracks = tb.getNumTracks();
        int numScenes = tb.getNumScenes();
        int maxCols = flipSession ? numScenes : numTracks;
        int n = maxRows = flipSession ? numTracks : numScenes;
        if (this.rowDisplayMode != RowDisplayMode.ALL) {
            maxRows /= 2;
        }
        Display d = ((PushControlSurface)this.surface).getDisplay().clear();
        for (int col = 0; col < maxCols; ++col) {
            for (int row = 0; row < maxRows; ++row) {
                double[] color;
                ISlot slot;
                int y;
                int x = flipSession ? row : col;
                int n2 = y = flipSession ? col : row;
                if (this.rowDisplayMode == RowDisplayMode.LOWER) {
                    if (flipSession) {
                        x += maxRows;
                    } else {
                        y += maxRows;
                    }
                }
                if (!(slot = tb.getTrack(x).getSlot(y)).doesExist()) continue;
                String optimizedName = StringUtils.shortenAndFixASCII(slot.getName(8), 8);
                if (optimizedName.length() == 0 && ((color = slot.getColor())[0] != 0.0 || color[1] != 0.0 || color[2] != 0.0)) {
                    optimizedName = "[------]";
                }
                d.setCell(row, col, optimizedName);
            }
        }
        d.allDone();
    }

    private void updateDisplay2Scenes() {
        ISceneBank sceneBank = this.trackBank.getSceneBank();
        int maxCols = 8;
        int maxRows = this.rowDisplayMode == RowDisplayMode.ALL ? 8 : 4;
        DisplayMessage message = ((PushDisplay)((PushControlSurface)this.surface).getDisplay()).createMessage();
        for (int col = 0; col < 8; ++col) {
            String[] items = new String[maxRows];
            ArrayList<double[]> slotColors = new ArrayList<double[]>(maxRows);
            for (int row = 0; row < maxRows; ++row) {
                IScene scene;
                int sceneIndex = (maxRows - 1 - row) * 8 + col;
                if (this.rowDisplayMode == RowDisplayMode.LOWER) {
                    sceneIndex += 32;
                }
                items[row] = (scene = sceneBank.getScene(sceneIndex)).doesExist() ? scene.getName() : "";
                slotColors.add(scene.doesExist() ? DAWColors.getColorEntry(this.trackBank.getColorOfFirstClipInScene(sceneIndex)) : BLACK);
            }
            message.addBoxListElement(items, slotColors);
        }
        message.send();
    }

    private void updateDisplay2Clips() {
        int maxRows;
        IChannelBank tb = this.model.getCurrentTrackBank();
        DisplayMessage message = ((PushDisplay)((PushControlSurface)this.surface).getDisplay()).createMessage();
        boolean flipSession = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isFlipSession();
        int numTracks = tb.getNumTracks();
        int numScenes = tb.getNumScenes();
        int maxCols = flipSession ? numScenes : numTracks;
        int n = maxRows = flipSession ? numTracks : numScenes;
        if (this.rowDisplayMode != RowDisplayMode.ALL) {
            maxRows /= 2;
        }
        for (int col = 0; col < maxCols; ++col) {
            String[] items = new String[maxRows];
            ArrayList<double[]> slotColors = new ArrayList<double[]>(maxRows);
            for (int row = 0; row < maxRows; ++row) {
                ISlot slot;
                int y;
                int x = flipSession ? row : col;
                int n2 = y = flipSession ? col : row;
                if (this.rowDisplayMode == RowDisplayMode.LOWER) {
                    if (flipSession) {
                        x += maxRows;
                    } else {
                        y += maxRows;
                    }
                }
                items[row] = (slot = tb.getTrack(x).getSlot(y)).doesExist() ? slot.getName() : "";
                slotColors.add(slot.getColor());
            }
            message.addBoxListElement(items, slotColors);
        }
        message.send();
    }

    private static enum RowDisplayMode {
        ALL,
        UPPER,
        LOWER;

    }
}

