/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ScalesMode
extends BaseMode {
    private Scales scales;

    public ScalesMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
        this.scales = model.getScales();
    }

    @Override
    public void onValueKnob(int index, int value) {
        if (index != 0) {
            return;
        }
        if (!this.increaseKnobMovement()) {
            return;
        }
        this.scales.changeScale(value);
        this.update();
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index == 0) {
            if (this.isPush2) {
                this.scales.nextScale();
            } else {
                this.scales.prevScale();
            }
        } else if (index > 0 && index < 7) {
            this.scales.setScaleOffset(index - 1);
        }
        this.update();
    }

    @Override
    public void updateFirstRow() {
        int offset = this.scales.getScaleOffset();
        ColorManager cm = this.model.getColorManager();
        for (int i = 0; i < 8; ++i) {
            boolean isFirstOrLast = i == 0 || i == 7;
            ((PushControlSurface)this.surface).updateButton(20 + i, i == 7 ? cm.getColor("BUTTON_COLOR_OFF") : (isFirstOrLast ? (this.isPush2 ? 70 : 7) : cm.getColor(offset == i - 1 ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON")));
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index == 0) {
            if (this.isPush2) {
                this.scales.prevScale();
            } else {
                this.scales.nextScale();
            }
        } else if (index == 7) {
            this.scales.toggleChromatic();
        } else {
            this.scales.setScaleOffset(index + 5);
        }
        this.update();
    }

    @Override
    public void updateSecondRow() {
        int offset = this.scales.getScaleOffset();
        ColorManager cm = this.model.getColorManager();
        for (int i = 0; i < 8; ++i) {
            boolean isFirstOrLast = i == 0 || i == 7;
            ((PushControlSurface)this.surface).updateButton(102 + i, isFirstOrLast ? (this.isPush2 ? 65 : 10) : cm.getColor(offset == i - 1 + 6 ? "BUTTON_COLOR2_HI" : "BUTTON_COLOR2_ON"));
        }
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        Scale scale = this.scales.getScale();
        int offset = this.scales.getScaleOffset();
        Scale[] scaleValues = Scale.values();
        String rangeText = this.scales.getRangeText();
        d.setBlock(0, 0, PushDisplay.RIGHT_ARROW + scale.getName()).clearBlock(0, 1).clearBlock(0, 2).setBlock(0, 3, rangeText).done(0);
        int pos = scale.ordinal() + 1;
        String name1 = pos < scaleValues.length ? scaleValues[pos].getName() : "";
        d.setBlock(1, 0, " " + name1).clearBlock(1, 1).clearBlock(1, 2).clearBlock(1, 3).done(1);
        String name2 = ++pos < scaleValues.length ? scaleValues[pos].getName() : "";
        d.setCell(2, 0, " " + name2);
        for (int i = 0; i < 6; ++i) {
            d.setCell(2, i + 1, "  " + (offset == i ? PushDisplay.RIGHT_ARROW : " ") + Scales.BASES[i]);
        }
        d.clearCell(2, 7).done(2);
        String name3 = ++pos < scaleValues.length ? scaleValues[pos].getName() : "";
        d.setCell(3, 0, " " + name3);
        for (int i = 6; i < 12; ++i) {
            d.setCell(3, i - 5, "  " + (offset == i ? PushDisplay.RIGHT_ARROW : " ") + Scales.BASES[i]);
        }
        d.setCell(3, 7, this.scales.isChromatic() ? "Chromatc" : "In Key").done(3);
    }

    @Override
    public void updateDisplay2() {
        int i;
        Scale scale = this.scales.getScale();
        int offset = this.scales.getScaleOffset();
        Scale[] scaleValues = Scale.values();
        String rangeText = this.scales.getRangeText();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        String[] items = new String[6];
        boolean[] selected = new boolean[6];
        for (i = 0; i < 6; ++i) {
            int pos = scale.ordinal() + i;
            items[i] = pos < scaleValues.length ? scaleValues[pos].getName() : "";
            selected[i] = i == 0;
        }
        message.addListElement(items, selected);
        for (i = 0; i < 6; ++i) {
            message.addOptionElement(i == 3 ? "Note range: " + rangeText : "", Scales.BASES[6 + i], offset == 6 + i, "", Scales.BASES[i], offset == i, false);
        }
        message.addOptionElement("", this.scales.isChromatic() ? "Chromatc" : "In Key", this.scales.isChromatic(), "", "", false, false);
        display.send(message);
    }

    private void update() {
        ((PushControlSurface)this.surface).getViewManager().getActiveView().updateNoteMapping();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        config.setScale(this.scales.getScale().getName());
        config.setScaleBase(Scales.BASES[this.scales.getScaleOffset()]);
        config.setScaleInKey(!this.scales.isChromatic());
    }
}

