/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.ScaleLayout;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ScaleLayoutMode
extends BaseMode {
    private Scales scales;

    public ScaleLayoutMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.scales = model.getScales();
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        int sl = this.scales.getScaleLayout().ordinal();
        String[] names = ScaleLayout.getNames();
        if (index < names.length / 2) {
            this.scales.setScaleLayout(ScaleLayout.getByName(names[index * 2 + sl % 2]));
        } else if (index == 7) {
            this.scales.setScaleLayout(ScaleLayout.getByName(names[sl / 2 * 2 + (sl % 2 == 0 ? 1 : 0)]));
        } else {
            return;
        }
        ((PushControlSurface)this.surface).getViewManager().getActiveView().updateNoteMapping();
        ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).setScaleLayout(this.scales.getScaleLayout().getName());
    }

    @Override
    public void updateFirstRow() {
        int sl = this.scales.getScaleLayout().ordinal();
        int pos = sl / 2;
        for (int i = 0; i < ScaleLayout.getNames().length / 2; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, pos == i ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
        }
        ((PushControlSurface)this.surface).updateButton(25, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(26, "BUTTON_COLOR_OFF");
        ((PushControlSurface)this.surface).updateButton(27, "BUTTON_COLOR_ON");
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        int sl = this.scales.getScaleLayout().ordinal();
        int pos = sl / 2;
        String[] names = ScaleLayout.getNames();
        d.clear().setBlock(1, 0, "Scale layout:");
        for (int i = 0; i < names.length; i += 2) {
            d.setCell(3, i / 2, (pos == i / 2 ? PushDisplay.RIGHT_ARROW : " ") + names[i].replace(" ^", ""));
        }
        d.setCell(3, 7, sl % 2 == 0 ? "Horizontal" : "Vertical");
        d.allDone();
    }

    @Override
    public void updateDisplay2() {
        int sl = this.scales.getScaleLayout().ordinal();
        int pos = sl / 2;
        String[] names = ScaleLayout.getNames();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        for (int i = 0; i < names.length; i += 2) {
            message.addOptionElement("", "", false, i == 0 ? "Scale layout" : "", names[i].replace(" ^", ""), pos == i / 2, false);
        }
        message.addOptionElement("", "", false, "", "", false, false);
        message.addOptionElement("", "", false, "", "", false, false);
        message.addOptionElement("", "", false, "", sl % 2 == 0 ? "Horizontal" : "Vertical", false, false);
        display.send(message);
    }
}

