/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class RibbonMode
extends BaseMode {
    private static final int[] MIDI_CCS = new int[]{1, 11, 7, 64};
    private static final String[] CC_QUICK_SELECT = new String[]{"Modulation", "Expression", "Volume", "Sustain", "", "", ""};
    private static final String[] FUNCTION = new String[]{"Pitchbend", "CC", "CC/Pitch", "Pitch/CC", "Fader", "", ""};
    private static final int[] FUNCTION_IDS = new int[]{0, 1, 2, 3, 4};

    public RibbonMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        if (index == 7) {
            PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
            config.setRibbonModeCC(this.model.getValueChanger().changeValue(value, config.getRibbonModeCCVal(), 1.0, 128));
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index < 5) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).setRibbonMode(index);
        } else {
            ((PushControlSurface)this.surface).getModeManager().restoreMode();
        }
    }

    @Override
    public void updateFirstRow() {
        int i;
        int ribbonMode = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getRibbonMode();
        for (i = 0; i < 5; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, ribbonMode == 0 + i ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
        }
        for (i = 5; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, "BUTTON_COLOR_OFF");
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index < 4) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).setRibbonModeCC(MIDI_CCS[index]);
        } else {
            ((PushControlSurface)this.surface).getModeManager().restoreMode();
        }
    }

    @Override
    public void updateSecondRow() {
        int i;
        for (i = 0; i < 4; ++i) {
            ((PushControlSurface)this.surface).updateButton(102 + i, this.isPush2 ? "BUTTON_COLOR_ON" : "BUTTON_COLOR2_ON");
        }
        for (i = 4; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(102 + i, "BUTTON_COLOR_OFF");
        }
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        String ribbonModeCC = Integer.toString(config.getRibbonModeCCVal());
        int ribbonMode = config.getRibbonMode();
        d.clear().setCell(0, 0, "Modulatn").setCell(0, 1, "Expressn").setCell(0, 2, "Volume").setCell(0, 3, "Sustain").setCell(0, 7, "Midi CC");
        d.setCell(1, 7, ribbonModeCC).setCell(3, 0, (ribbonMode == 0 ? PushDisplay.RIGHT_ARROW : "") + "Pitchbd").setCell(3, 1, (ribbonMode == 1 ? PushDisplay.RIGHT_ARROW : "") + "CC").setCell(3, 2, (ribbonMode == 2 ? PushDisplay.RIGHT_ARROW : "") + "CC/Pitch").setCell(3, 3, (ribbonMode == 3 ? PushDisplay.RIGHT_ARROW : "") + "Pitch/CC").setCell(3, 4, (ribbonMode == 4 ? PushDisplay.RIGHT_ARROW : "") + "Fader").allDone();
    }

    @Override
    public void updateDisplay2() {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        String ribbonModeCC = Integer.toString(config.getRibbonModeCCVal());
        int ribbonMode = config.getRibbonMode();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        for (int i = 0; i < 7; ++i) {
            message.addOptionElement(i == 0 ? "CC Quick Select" : "", CC_QUICK_SELECT[i], false, i == 0 ? "Function" : "", FUNCTION[i], i < FUNCTION_IDS.length && ribbonMode == FUNCTION_IDS[i], false);
        }
        message.addParameterElement("Midi CC", -1, ribbonModeCC, this.isKnobTouched[5], -1);
        display.send(message);
    }
}

