/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.View;
import de.mossgrabers.framework.view.ViewManager;

public class NoteViewSelectMode
extends BaseMode {
    private static final Integer[] VIEWS = new Integer[]{Views.VIEW_PLAY, Views.VIEW_PIANO, Views.VIEW_SEQUENCER, Views.VIEW_RAINDROPS, Views.VIEW_DRUM, Views.VIEW_DRUM4, Views.VIEW_DRUM8, Views.VIEW_DRUM64};
    private static final Integer[] VIEWS_TOP = new Integer[]{null, null, null, null, null, null, Views.VIEW_CLIP, Views.VIEW_PRG_CHANGE};

    public NoteViewSelectMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.activateView(VIEWS[index]);
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.activateView(VIEWS_TOP[index]);
        }
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        d.clear().setBlock(1, 0, "Note view:");
        for (int i = 0; i < VIEWS.length; ++i) {
            if (VIEWS[i] != null) {
                View view = viewManager.getView(VIEWS[i]);
                d.setCell(3, i, view == null ? "" : (viewManager.isActiveView(VIEWS[i]) ? PushDisplay.RIGHT_ARROW : "") + view.getName());
            }
            if (VIEWS_TOP[i] == null) continue;
            d.setCell(0, i, (viewManager.isActiveView(VIEWS_TOP[i]) ? PushDisplay.RIGHT_ARROW : "") + viewManager.getView(VIEWS_TOP[i]).getName());
        }
        d.allDone();
    }

    @Override
    public void updateDisplay2() {
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        for (int i = 0; i < VIEWS.length; ++i) {
            View view;
            String menuBottomName = "";
            if (VIEWS[i] != null && (view = viewManager.getView(VIEWS[i])) != null) {
                menuBottomName = view.getName();
            }
            String menuTopName = VIEWS_TOP[i] == null ? "" : viewManager.getView(VIEWS_TOP[i]).getName();
            boolean isMenuBottomSelected = VIEWS[i] != null && viewManager.isActiveView(VIEWS[i]);
            boolean isMenuTopSelected = VIEWS_TOP[i] != null && viewManager.isActiveView(VIEWS_TOP[i]);
            message.addOptionElement("", menuTopName, isMenuTopSelected, i == 0 ? "Note view" : "", menuBottomName, isMenuBottomSelected, false);
        }
        display.send(message);
    }

    @Override
    public void updateFirstRow() {
        ColorManager colorManager = this.model.getColorManager();
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, colorManager.getColor(VIEWS[i] == null ? "BUTTON_COLOR_OFF" : (viewManager.isActiveView(VIEWS[i]) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON")));
        }
    }

    @Override
    public void updateSecondRow() {
        ColorManager colorManager = this.model.getColorManager();
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(102 + i, colorManager.getColor(VIEWS_TOP[i] == null ? "BUTTON_COLOR_OFF" : (viewManager.isActiveView(VIEWS_TOP[i]) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON")));
        }
    }

    private void activateView(Integer viewID) {
        if (viewID == null) {
            return;
        }
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        if (viewManager.getView(viewID) == null) {
            return;
        }
        viewManager.setActiveView(viewID);
        ITrack selectedTrack = this.model.getSelectedTrack();
        if (selectedTrack != null) {
            viewManager.setPreferredView(selectedTrack.getPosition(), viewID);
        }
        ((PushControlSurface)this.surface).getModeManager().restoreMode();
    }
}

