/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;

public class NoteMode
extends BaseMode {
    ICursorClip clip = null;
    double noteLength = 1.0;
    int noteVelocity = 127;
    int step = 0;
    int note = 60;

    public NoteMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    public void setValues(ICursorClip clip, int step, int note, double noteLength, int noteVelocity) {
        this.clip = clip;
        this.step = step;
        this.note = note;
        this.noteLength = noteLength;
        this.noteVelocity = noteVelocity;
    }

    @Override
    public void onValueKnob(int index, int value) {
        IValueChanger valueChanger = this.model.getValueChanger();
        switch (index) {
            case 0: {
                if (!this.increaseKnobMovement()) {
                    return;
                }
                double speed = valueChanger.calcKnobSpeed(value, 1.0);
                this.noteLength += speed;
                this.clip.clearStep(this.step, this.note);
                this.clip.setStep(this.step, this.note, this.noteVelocity, this.noteLength);
                break;
            }
            case 1: {
                if (!this.increaseKnobMovement()) {
                    return;
                }
                double speed2 = valueChanger.calcKnobSpeed(value, 0.1);
                this.noteLength += speed2;
                this.clip.clearStep(this.step, this.note);
                this.clip.setStep(this.step, this.note, this.noteVelocity, this.noteLength);
                break;
            }
            case 2: {
                this.noteVelocity = valueChanger.changeValue(value, this.noteVelocity, 1.0, 128);
                this.clip.clearStep(this.step, this.note);
                this.clip.setStep(this.step, this.note, this.noteVelocity, this.noteLength);
            }
        }
    }

    @Override
    public void updateDisplay1() {
        int quarters = (int)Math.floor(this.noteLength);
        int fine = (int)Math.floor(this.noteLength * 100.0) % 100;
        Display d = ((PushControlSurface)this.surface).getDisplay();
        d.clear().setCell(0, 0, "Quarters").setCell(1, 0, Integer.toString(quarters));
        d.setCell(0, 1, "Fine").setCell(1, 1, Integer.toString(fine));
        d.setCell(0, 2, "Velocity").setCell(1, 2, Integer.toString(this.noteVelocity * 100 / 127) + "%").allDone();
    }

    @Override
    public void updateDisplay2() {
        int quarters = (int)Math.floor(this.noteLength);
        int fine = (int)Math.floor(this.noteLength * 100.0) % 100;
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        message.addParameterElement("Quarters", quarters, Integer.toString(quarters), this.isKnobTouched[0], -1);
        message.addParameterElement("Fine", fine, Integer.toString(fine), this.isKnobTouched[1], -1);
        int parameterValue = this.noteVelocity * 1023 / 127;
        message.addParameterElement("Velocity", parameterValue, Integer.toString(this.noteVelocity * 100 / 127) + "%", this.isKnobTouched[2], parameterValue);
        for (int i = 3; i < 8; ++i) {
            message.addOptionElement("", "", false, "", "", false, false);
        }
        display.send(message);
    }
}

