/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class InfoMode
extends BaseMode {
    public InfoMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (index == 0) {
            ((PushControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_SETUP);
        }
    }

    @Override
    public void updateSecondRow() {
        ((PushControlSurface)this.surface).updateButton(102, "BUTTON_COLOR_ON");
        ((PushControlSurface)this.surface).updateButton(103, "BUTTON_COLOR_HI");
        for (int i = 2; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(102 + i, "BUTTON_COLOR_OFF");
        }
    }

    @Override
    public void updateDisplay1() {
    }

    @Override
    public void updateDisplay2() {
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        message.addOptionElement("  Firmware: " + ((PushControlSurface)this.surface).getMajorVersion() + "." + ((PushControlSurface)this.surface).getMinorVersion() + " Build " + ((PushControlSurface)this.surface).getBuildNumber(), "Setup", false, "", "", false, true);
        message.addOptionElement("", "Info", true, "", "", false, true);
        message.addEmptyElement();
        message.addOptionElement("Board Revision: " + ((PushControlSurface)this.surface).getBoardRevision(), "", false, "", "", false, false);
        message.addEmptyElement();
        message.addOptionElement("        Serial Number: " + ((PushControlSurface)this.surface).getSerialNumber(), "", false, "", "", false, false);
        message.addEmptyElement();
        message.addEmptyElement();
        display.send(message);
    }
}

