/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IParameter;

public class GrooveMode
extends BaseMode {
    public GrooveMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onActivate() {
        this.setActive(true);
    }

    @Override
    public void onDeactivate() {
        this.setActive(false);
    }

    @Override
    public void onValueKnob(int index, int value) {
        if (index == 0) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).changeQuantizeAmount(value);
        } else if (index > 1) {
            this.model.getGroove().getParameters()[index - 2].changeValue(value);
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        IParameter[] parameters = this.model.getGroove().getParameters();
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
            if (index == 0) {
                ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).resetQuantizeAmount();
            } else if (index > 1 && index - 2 < parameters.length) {
                parameters[index - 2].resetValue();
            }
        }
        if (index > 1 && index - 2 < parameters.length) {
            parameters[index - 2].touchValue(isTouched);
        }
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        IParameter[] parameters = this.model.getGroove().getParameters();
        int quantizeAmount = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getQuantizeAmount();
        d.clear().setCell(0, 0, "Quant Amnt").setCell(1, 0, quantizeAmount + "%").setCell(2, 0, quantizeAmount * 1023 / 100, Format.FORMAT_VALUE);
        for (int i = 0; i < parameters.length; ++i) {
            d.setCell(0, 2 + i, parameters[i].getName(8)).setCell(1, 2 + i, parameters[i].getDisplayedValue(8)).setCell(2, 2 + i, parameters[i].getValue(), Format.FORMAT_VALUE);
        }
        d.allDone();
    }

    @Override
    public void updateDisplay2() {
        int i;
        IParameter[] parameters = this.model.getGroove().getParameters();
        int quantizeAmount = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getQuantizeAmount();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        message.addParameterElement("Quant Amnt", quantizeAmount * 1023 / 100, quantizeAmount + "%", this.isKnobTouched[0], -1);
        message.addOptionElement("     Groove", "", false, "", "", false, false);
        for (i = 0; i < parameters.length; ++i) {
            message.addParameterElement(parameters[i].getName(10), parameters[i].getValue(), parameters[i].getDisplayedValue(8), this.isKnobTouched[i], -1);
        }
        for (i = parameters.length; i < 6; ++i) {
            message.addEmptyElement();
        }
        display.send(message);
    }

    private void setActive(boolean enable) {
        IGroove groove = this.model.getGroove();
        groove.enableObservers(enable);
        groove.setIndication(enable);
    }
}

