/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IArranger;
import de.mossgrabers.framework.daw.IMixer;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class FrameMode
extends BaseMode {
    private static final String ROW0 = "Layouts:                  Panels:                                   ";
    private static final String ROW1 = "Arrange  Mix     Edit     Notes   Automate Device  Mixer    Inspectr";
    private static final String ARRANGER_ROW2 = "Arranger:                                                           ";
    private static final String ARRANGER_ROW3 = "ClpLnchr I/O     Markers  TimelineFXTracks Follow  TrckHght Full    ";
    private static final String MIXER_ROW2 = "Mixer:                                                              ";
    private static final String MIXER_ROW3 = "ClpLnchr I/O     CrossFde Device  Meters   Sends            Full    ";
    private static final String EMPTY = "                                                                    ";
    private static final String[] LAYOUTS1 = new String[]{"Layouts", "", "", "Panels", "", "", "", ""};
    private static final String[] LAYOUTS2 = new String[]{"Arrange", "Mix", "Edit", "Notes", "Automate", "Device", "Mixer", "Inspector"};
    private static final String[] ARRANGER1 = new String[]{"Arranger", "", "", "", "", "", "", ""};
    private static final String[] ARRANGER2 = new String[]{"Clip Launcher", "I/O", "Markers", "Timeline", "FX Tracks", "Follow", "Track Height", "Fullscreen"};
    private static final String[] MIXER1 = new String[]{"Mixer", "", "", "", "", "", "", ""};
    private static final String[] MIXER2 = new String[]{"Clip Launcher", "I/O", "Crossfader", "Device", "Meters", "Sends", "", "Fullscreen"};

    public FrameMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onActivate() {
        this.setActive(true);
    }

    @Override
    public void onDeactivate() {
        this.setActive(false);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IApplication app = this.model.getApplication();
        switch (index) {
            case 0: {
                app.setPanelLayout("ARRANGE");
                break;
            }
            case 1: {
                app.setPanelLayout("MIX");
                break;
            }
            case 2: {
                app.setPanelLayout("EDIT");
                break;
            }
            case 3: {
                app.toggleNoteEditor();
                break;
            }
            case 4: {
                app.toggleAutomationEditor();
                break;
            }
            case 5: {
                app.toggleDevices();
                break;
            }
            case 6: {
                app.toggleMixer();
                break;
            }
            case 7: {
                app.toggleInspector();
            }
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IApplication app = this.model.getApplication();
        if (app.isArrangeLayout()) {
            IArranger arrange = this.model.getArranger();
            switch (index) {
                case 0: {
                    arrange.toggleClipLauncher();
                    break;
                }
                case 1: {
                    arrange.toggleIoSection();
                    break;
                }
                case 2: {
                    arrange.toggleCueMarkerVisibility();
                    break;
                }
                case 3: {
                    arrange.toggleTimeLine();
                    break;
                }
                case 4: {
                    arrange.toggleEffectTracks();
                    break;
                }
                case 5: {
                    arrange.togglePlaybackFollow();
                    break;
                }
                case 6: {
                    arrange.toggleTrackRowHeight();
                    break;
                }
                case 7: {
                    app.toggleFullScreen();
                }
            }
        } else if (app.isMixerLayout()) {
            IMixer mix = this.model.getMixer();
            switch (index) {
                case 0: {
                    mix.toggleClipLauncherSectionVisibility();
                    break;
                }
                case 1: {
                    mix.toggleIoSectionVisibility();
                    break;
                }
                case 2: {
                    mix.toggleCrossFadeSectionVisibility();
                    break;
                }
                case 3: {
                    mix.toggleDeviceSectionVisibility();
                    break;
                }
                case 4: {
                    mix.toggleMeterSectionVisibility();
                    break;
                }
                case 5: {
                    mix.toggleSendsSectionVisibility();
                    break;
                }
                case 7: {
                    app.toggleFullScreen();
                }
            }
        }
    }

    @Override
    public void updateDisplay1() {
        IApplication app = this.model.getApplication();
        Display d = ((PushControlSurface)this.surface).getDisplay();
        d.setRow(0, ROW0).setRow(1, ROW1).setRow(2, app.isArrangeLayout() ? ARRANGER_ROW2 : (app.isMixerLayout() ? MIXER_ROW2 : EMPTY)).setRow(3, app.isArrangeLayout() ? ARRANGER_ROW3 : (app.isMixerLayout() ? MIXER_ROW3 : EMPTY));
    }

    @Override
    public void updateDisplay2() {
        IApplication app = this.model.getApplication();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        for (int i = 0; i < ARRANGER1.length; ++i) {
            message.addOptionElement(app.isArrangeLayout() ? ARRANGER1[i] : (app.isMixerLayout() ? MIXER1[i] : ""), app.isArrangeLayout() ? ARRANGER2[i] : (app.isMixerLayout() ? MIXER2[i] : ""), this.getSecondRowButtonState(i) > 0, LAYOUTS1[i], LAYOUTS2[i], this.getFirstRowButtonState(i), false);
        }
        display.send(message);
    }

    @Override
    public void updateFirstRow() {
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, this.getFirstRowButtonState(i) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
        }
    }

    @Override
    public void updateSecondRow() {
        for (int i = 0; i < 8; ++i) {
            int state = this.getSecondRowButtonState(i);
            ((PushControlSurface)this.surface).updateButton(102 + i, state == 1 ? "BUTTON_COLOR2_HI" : (state == 0 ? "BUTTON_COLOR2_ON" : "BUTTON_COLOR_OFF"));
        }
    }

    private boolean getFirstRowButtonState(int index) {
        switch (index) {
            case 0: {
                return this.model.getApplication().isArrangeLayout();
            }
            case 1: {
                return this.model.getApplication().isMixerLayout();
            }
            case 2: {
                return this.model.getApplication().isEditLayout();
            }
        }
        return false;
    }

    private int getSecondRowButtonState(int index) {
        IApplication app = this.model.getApplication();
        if (app.isArrangeLayout()) {
            IArranger arrange = this.model.getArranger();
            switch (index) {
                case 0: {
                    return arrange.isClipLauncherVisible() ? 1 : 0;
                }
                case 1: {
                    return arrange.isIoSectionVisible() ? 1 : 0;
                }
                case 2: {
                    return arrange.areCueMarkersVisible() ? 1 : 0;
                }
                case 3: {
                    return arrange.isTimelineVisible() ? 1 : 0;
                }
                case 4: {
                    return arrange.areEffectTracksVisible() ? 1 : 0;
                }
                case 5: {
                    return arrange.isPlaybackFollowEnabled() ? 1 : 0;
                }
                case 6: {
                    return arrange.hasDoubleRowTrackHeight() ? 1 : 0;
                }
            }
            return 0;
        }
        if (app.isMixerLayout()) {
            IMixer mix = this.model.getMixer();
            switch (index) {
                case 0: {
                    return mix.isClipLauncherSectionVisible() ? 1 : 0;
                }
                case 1: {
                    return mix.isIoSectionVisible() ? 1 : 0;
                }
                case 2: {
                    return mix.isCrossFadeSectionVisible() ? 1 : 0;
                }
                case 3: {
                    return mix.isDeviceSectionVisible() ? 1 : 0;
                }
                case 4: {
                    return mix.isMeterSectionVisible() ? 1 : 0;
                }
                case 5: {
                    return mix.isSendSectionVisible() ? 1 : 0;
                }
                case 6: {
                    return -1;
                }
            }
            return 0;
        }
        return -1;
    }

    private void setActive(boolean enable) {
        this.model.getArranger().enableObservers(enable);
        this.model.getMixer().enableObservers(enable);
    }
}

