/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.command.trigger.clip.TemporaryNewCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class FixedMode
extends BaseMode {
    public FixedMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).setNewClipLength(index);
        ((PushControlSurface)this.surface).getModeManager().restoreMode();
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        new TemporaryNewCommand(index, this.model, this.surface).execute(ButtonEvent.DOWN);
        ((PushControlSurface)this.surface).getModeManager().restoreMode();
    }

    @Override
    public void updateFirstRow() {
        ColorManager colorManager = this.model.getColorManager();
        Object configuration = ((PushControlSurface)this.surface).getConfiguration();
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, colorManager.getColor(configuration.getNewClipLength() == i ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON"));
        }
    }

    @Override
    public void updateSecondRow() {
        ColorManager colorManager = this.model.getColorManager();
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(102 + i, colorManager.getColor("BUTTON_COLOR_ON"));
        }
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        d.clear().setBlock(1, 0, "Create Clip (leng").setBlock(1, 1, "th not stored):");
        int newClipLength = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getNewClipLength();
        d.setBlock(2, 0, "New Clip Length:");
        for (int i = 0; i < 8; ++i) {
            d.setCell(0, i, AbstractConfiguration.NEW_CLIP_LENGTH_VALUES[i]);
            d.setCell(3, i, (newClipLength == i ? PushDisplay.RIGHT_ARROW : "") + AbstractConfiguration.NEW_CLIP_LENGTH_VALUES[i]);
        }
        d.allDone();
    }

    @Override
    public void updateDisplay2() {
        int newClipLength = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getNewClipLength();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        for (int i = 0; i < 8; ++i) {
            message.addOptionElement(i == 0 ? "Create Clip (length not stored)" : "", AbstractConfiguration.NEW_CLIP_LENGTH_VALUES[i], false, i == 0 ? "New Clip Length" : "", AbstractConfiguration.NEW_CLIP_LENGTH_VALUES[i], newClipLength == i, false);
        }
        display.send(message);
    }
}

