/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;

public class ConfigurationMode
extends BaseMode {
    public ConfigurationMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        if (index == 0 || index == 1) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).changePadThreshold(value);
        } else if (index == 2 || index == 3) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).changeVelocityCurve(value);
        }
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        d.clear().setBlock(0, 0, "Pad Threshold").setBlock(1, 0, ((PushControlSurface)this.surface).getSelectedPadThreshold());
        d.setBlock(0, 1, "Velocity Curve").setBlock(1, 1, ((PushControlSurface)this.surface).getSelectedVelocityCurve());
        d.setBlock(0, 3, "Firmware: " + ((PushControlSurface)this.surface).getMajorVersion() + "." + ((PushControlSurface)this.surface).getMinorVersion()).allDone();
        if (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getPadThreshold() < 20) {
            d.setRow(3, " Warning:Low threshold maycause stuck pads ");
        }
    }

    @Override
    public void updateDisplay2() {
    }
}

