/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Arrays;

public abstract class BaseMode
extends AbstractMode<PushControlSurface, PushConfiguration> {
    protected static final int SCROLL_RATE = 8;
    private int movementCounter = 0;
    protected boolean[] isKnobTouched;
    protected final boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();

    public BaseMode(PushControlSurface surface, IModel model) {
        super(surface, model);
        this.isKnobTouched = new boolean[8];
        Arrays.fill(this.isKnobTouched, false);
    }

    public boolean isAKnobTouched() {
        for (boolean anIsKnobTouched : this.isKnobTouched) {
            if (!anIsKnobTouched) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateDisplay() {
        if (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2()) {
            this.updateDisplay2();
        } else {
            this.updateDisplay1();
        }
    }

    public abstract void updateDisplay1();

    public abstract void updateDisplay2();

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
        if (row == 0) {
            this.onFirstRow(index, event);
        } else {
            this.onSecondRow(index, event);
        }
    }

    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.model.getCurrentTrackBank().getTrack(index).select();
        }
    }

    public void onSecondRow(int index, ButtonEvent event) {
    }

    @Override
    public void updateFirstRow() {
        this.disableFirstRow();
    }

    @Override
    public void updateSecondRow() {
        this.disableSecondRow();
    }

    protected void disableFirstRow() {
        ColorManager colorManager = this.model.getColorManager();
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, colorManager.getColor("BUTTON_COLOR_OFF"));
        }
    }

    protected void disableSecondRow() {
        ColorManager colorManager = this.model.getColorManager();
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(102 + i, colorManager.getColor("BUTTON_COLOR_OFF"));
        }
    }

    protected void checkStopAutomationOnKnobRelease(boolean isTouched) {
        if (!((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isStopAutomationOnKnobRelease() || isTouched) {
            return;
        }
        ITransport transport = this.model.getTransport();
        if (transport.isWritingArrangerAutomation()) {
            transport.toggleWriteArrangerAutomation();
        }
        if (transport.isWritingClipLauncherAutomation()) {
            transport.toggleWriteClipLauncherAutomation();
        }
    }

    protected boolean increaseKnobMovement() {
        ++this.movementCounter;
        if (this.movementCounter < 8) {
            return false;
        }
        this.movementCounter = 0;
        return true;
    }
}

