/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class AutomationMode
extends BaseMode {
    public AutomationMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void updateDisplay1() {
        Display d = ((PushControlSurface)this.surface).getDisplay();
        String writeMode = this.model.getTransport().getAutomationWriteMode();
        d.clear().setBlock(1, 0, "Automation Mode:");
        for (int i = 0; i < ITransport.AUTOMATION_MODES.length; ++i) {
            d.setCell(3, i, (ITransport.AUTOMATION_MODES_VALUES[i].equals(writeMode) ? PushDisplay.RIGHT_ARROW : "") + ITransport.AUTOMATION_MODES[i]);
        }
        d.allDone();
    }

    @Override
    public void updateDisplay2() {
        String writeMode = this.model.getTransport().getAutomationWriteMode();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        for (int i = 0; i < 8; ++i) {
            message.addOptionElement("", "", false, i == 0 ? "Automation Mode" : "", i < ITransport.AUTOMATION_MODES.length ? ITransport.AUTOMATION_MODES[i] : "", i < ITransport.AUTOMATION_MODES.length && ITransport.AUTOMATION_MODES_VALUES[i].equals(writeMode), false);
        }
        display.send(message);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index < ITransport.AUTOMATION_MODES_VALUES.length) {
            this.model.getTransport().setAutomationWriteMode(ITransport.AUTOMATION_MODES_VALUES[index]);
        }
    }

    @Override
    public void updateFirstRow() {
        int i;
        String writeMode = this.model.getTransport().getAutomationWriteMode();
        ColorManager colorManager = this.model.getColorManager();
        for (i = 0; i < ITransport.AUTOMATION_MODES_VALUES.length; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, colorManager.getColor(ITransport.AUTOMATION_MODES_VALUES[i].equals(writeMode) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON"));
        }
        for (i = ITransport.AUTOMATION_MODES_VALUES.length; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(20 + i, colorManager.getColor("BUTTON_COLOR_OFF"));
        }
    }
}

