/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.mode;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IModel;

public class AccentMode
extends BaseMode {
    public AccentMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        IValueChanger valueChanger = this.model.getValueChanger();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        int fixedAccentValue = config.getFixedAccentValue();
        config.setAccentValue(Math.max(1, valueChanger.changeValue(value, fixedAccentValue, 1.0, 128)));
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        this.isKnobTouched[index] = isTouched;
    }

    @Override
    public void updateDisplay1() {
        int fixedAccentValue = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getFixedAccentValue();
        IValueChanger valueChanger = this.model.getValueChanger();
        Display d = ((PushControlSurface)this.surface).getDisplay();
        d.clear().setCell(0, 7, "Accent").setCell(1, 7, fixedAccentValue, Format.FORMAT_RAW).setCell(2, 7, valueChanger.toDAWValue(fixedAccentValue), Format.FORMAT_VALUE).allDone();
    }

    @Override
    public void updateDisplay2() {
        int fixedAccentValue = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getFixedAccentValue();
        IValueChanger valueChanger = this.model.getValueChanger();
        PushDisplay display = (PushDisplay)((PushControlSurface)this.surface).getDisplay();
        DisplayMessage message = display.createMessage();
        for (int i = 0; i < 8; ++i) {
            message.addParameterElement(i == 7 ? "Accent" : "", i == 7 ? valueChanger.toDisplayValue(valueChanger.toDAWValue(fixedAccentValue)) : 0, i == 7 ? Integer.toString(fixedAccentValue) : "", this.isKnobTouched[i], -1);
        }
        display.send(message);
    }
}

