/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display.model.grid;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.display.model.grid.ChannelSelectionGridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;

public class SendsGridElement
extends ChannelSelectionGridElement {
    final String[] sendNames = new String[]{"", "", "", ""};
    final String[] sendTexts = new String[]{"", "", "", ""};
    final int[] sendValues = new int[]{0, 0, 0, 0};
    final int[] modulatedSendValues = new int[]{0, 0, 0, 0};
    private boolean[] sendEdited = new boolean[]{false, false, false, false};
    private boolean isExMode;

    public SendsGridElement(String[] sendNames, String[] sendTexts, int[] sendValues, int[] modulatedSendValues, boolean[] sendEdited, String menuName, boolean isMenuSelected, String name, ColorEx color, boolean isSelected, ChannelType type, boolean isExMode) {
        super(menuName, isMenuSelected, name, color, isSelected, type);
        for (int i = 0; i < 4; ++i) {
            this.sendNames[i] = sendNames[i];
            this.sendTexts[i] = sendTexts[i];
            this.sendValues[i] = sendValues[i];
            this.modulatedSendValues[i] = modulatedSendValues[i];
            this.sendEdited[i] = sendEdited[i];
        }
        this.isExMode = isExMode;
    }

    @Override
    public void draw(IGraphicsContext gc, double left, double width, double height, PushConfiguration configuration) {
        double h;
        super.draw(gc, left, width, height, configuration);
        String name = this.getName();
        if (!(name != null && name.length() != 0 || this.isExMode)) {
            return;
        }
        double trackRowTop = height - 21.0 - 13.333333333333334 - 2.0;
        double sliderWidth = width - 15.333333333333334 - 1.0;
        double t = 18.333333333333336;
        double sliderAreaHeight = h = trackRowTop - 18.333333333333336;
        double sendRowHeight = sliderAreaHeight / 8.0;
        double sliderHeight = sendRowHeight - 4.0;
        ColorEx backgroundColor = configuration.getColorBackground();
        gc.fillRectangle(this.isExMode ? left - 2.0 : left, 18.333333333333336, this.isExMode ? width + 2.0 : width, this.isExMode ? h - 2.0 : h, this.isSelected() || this.isExMode ? configuration.getColorBackgroundLighter() : backgroundColor);
        double topy = 17.333333333333336 + (this.isExMode ? 0.0 : 2.0);
        ColorEx textColor = configuration.getColorText();
        ColorEx borderColor = configuration.getColorBorder();
        ColorEx faderColor = configuration.getColorFader();
        ColorEx editColor = configuration.getColorEdit();
        double faderLeft = left + 7.666666666666667;
        for (int i = 0; i < 4 && this.sendNames[i].length() != 0; ++i) {
            gc.drawTextInBounds(this.sendNames[i], faderLeft, topy + 2.0, sliderWidth, sendRowHeight, Align.LEFT, textColor, sendRowHeight);
            gc.fillRectangle(faderLeft, (topy += sendRowHeight) + 2.0, sliderWidth, sliderHeight, borderColor);
            double valueWidth = (double)this.sendValues[i] * sliderWidth / SendsGridElement.getMaxValue();
            boolean isSendModulated = this.modulatedSendValues[i] != -1;
            double modulatedValueWidth = isSendModulated ? (double)this.modulatedSendValues[i] * sliderWidth / SendsGridElement.getMaxValue() : valueWidth;
            double faderTop = topy + 2.0 + 1.0;
            gc.fillRectangle(faderLeft + 1.0, faderTop, modulatedValueWidth - 1.0, sliderHeight - 2.0, faderColor);
            if (this.sendEdited[i]) {
                boolean isTouched = this.sendTexts[i] != null && this.sendTexts[i].length() > 0;
                double w = isTouched ? 3.0 : 1.0;
                gc.fillRectangle(Math.min(faderLeft + sliderWidth - w - 1.0, faderLeft + valueWidth + 1.0), faderTop, w, sliderHeight - 2.0, editColor);
            }
            topy += sendRowHeight;
        }
        double boxWidth = sliderWidth / 2.0;
        double boxLeft = faderLeft + sliderWidth - boxWidth;
        topy = 17.333333333333336;
        ColorEx backgroundDarker = configuration.getColorBackgroundDarker();
        for (int i = 0; i < 4; ++i) {
            topy += sendRowHeight;
            if (this.sendTexts[i].length() > 0) {
                double volumeTextTop = topy + sliderHeight + 1.0 + (this.isExMode ? 0.0 : 2.0);
                gc.fillRectangle(boxLeft, volumeTextTop, boxWidth, 13.333333333333334, backgroundDarker);
                gc.strokeRectangle(boxLeft, volumeTextTop, boxWidth - 1.0, 13.333333333333334, borderColor);
                gc.drawTextInBounds(this.sendTexts[i], boxLeft, volumeTextTop, boxWidth, 13.333333333333334, Align.CENTER, textColor, 13.333333333333334);
            }
            topy += sendRowHeight;
        }
    }
}

