/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display.model.grid;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.display.model.grid.ChannelSelectionGridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.daw.resource.DeviceTypes;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;

public class ParamGridElement
extends ChannelSelectionGridElement {
    private final String paramName;
    private final String paramValueText;
    private final int paramValue;
    private int modulatedParamValue;
    private final boolean isTouched;
    private final String deviceName;

    public ParamGridElement(String menuName, boolean isMenuSelected, String name, ChannelType type, ColorEx color, boolean isSelected, String paramName, int paramValue, int modulatedParamValue, String paramValueText, boolean isTouched) {
        this(menuName, isMenuSelected, name, null, type, color, isSelected, paramName, paramValue, modulatedParamValue, paramValueText, isTouched);
    }

    public ParamGridElement(String menuName, boolean isMenuSelected, String name, String deviceName, ColorEx color, boolean isSelected, String paramName, int paramValue, int modulatedParamValue, String paramValueText, boolean isTouched) {
        this(menuName, isMenuSelected, name, deviceName, null, color, isSelected, paramName, paramValue, modulatedParamValue, paramValueText, isTouched);
    }

    private ParamGridElement(String menuName, boolean isMenuSelected, String name, String deviceName, ChannelType type, ColorEx color, boolean isSelected, String paramName, int paramValue, int modulatedParamValue, String paramValueText, boolean isTouched) {
        super(menuName, isMenuSelected, name, color, isSelected, type);
        this.deviceName = deviceName;
        this.paramName = paramName;
        this.paramValue = paramValue;
        this.modulatedParamValue = modulatedParamValue;
        this.paramValueText = paramValueText;
        this.isTouched = isTouched;
    }

    @Override
    public void draw(IGraphicsContext gc, double left, double width, double height, PushConfiguration configuration) {
        this.drawMenu(gc, left, width, configuration);
        boolean isValueMissing = this.paramValue == -1;
        boolean isModulated = this.modulatedParamValue != -1;
        double trackRowTop = height - 21.0 - 13.333333333333334 - 2.0;
        String name = this.getName();
        if (name != null && name.length() > 0) {
            this.drawTrackInfo(gc, left, width, height, trackRowTop, name, configuration);
        }
        if (this.paramName == null || this.paramName.length() == 0) {
            return;
        }
        double elementWidth = width - 15.333333333333334;
        double elementHeight = (trackRowTop - 25.000000000000004 - 7.666666666666667) / 3.0;
        ColorEx backgroundColor = configuration.getColorBackground();
        gc.fillRectangle(left, 18.333333333333336, width, trackRowTop - (isValueMissing ? 25.000000000000004 + elementHeight : 18.333333333333336), this.isTouched ? configuration.getColorBackgroundLighter() : backgroundColor);
        ColorEx textColor = configuration.getColorText();
        double fontSize = elementHeight * 2.0 / 3.0;
        gc.drawTextInBounds(this.paramName, left + 7.666666666666667 - 1.0, 17.333333333333336, elementWidth, elementHeight, Align.CENTER, textColor, fontSize);
        gc.drawTextInBounds(this.paramValueText, left + 7.666666666666667 - 1.0, 17.333333333333336 + elementHeight, elementWidth, elementHeight, Align.CENTER, textColor, fontSize);
        if (isValueMissing) {
            return;
        }
        double elementInnerWidth = elementWidth - 2.0;
        double maxValue = ParamGridElement.getMaxValue();
        double value = isModulated ? (double)this.modulatedParamValue : (double)this.paramValue;
        double valueSliderWidth = value >= maxValue - 1.0 ? elementInnerWidth : elementInnerWidth * value / maxValue;
        double innerTop = 25.000000000000004 + 2.0 * elementHeight + 1.0;
        ColorEx borderColor = configuration.getColorBorder();
        gc.fillRectangle(left + 7.666666666666667 - 1.0, 25.000000000000004 + 2.0 * elementHeight, elementWidth, elementHeight, borderColor);
        gc.fillRectangle(left + 7.666666666666667, innerTop, valueSliderWidth, elementHeight - 2.0, configuration.getColorFader());
        double w = this.isTouched ? 3.0 : 1.0;
        double valueWidth = (double)this.paramValue >= maxValue - 1.0 ? elementInnerWidth : elementInnerWidth * (double)this.paramValue / maxValue;
        gc.fillRectangle(left + 7.666666666666667 + Math.max(0.0, valueWidth - w), innerTop, w, elementHeight - 2.0, configuration.getColorEdit());
    }

    @Override
    public String getIcon() {
        if (this.deviceName != null) {
            return DeviceTypes.getIconId(this.deviceName);
        }
        return super.getIcon();
    }
}

