/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display.model.grid;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.display.model.grid.AbstractGridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;

public class OptionsGridElement
extends AbstractGridElement {
    private final String headerBottom;
    private final String headerTop;
    private final String menuBottomName;
    private final boolean isMenuBottomSelected;
    private final boolean useSmallTopMenu;

    public OptionsGridElement(String headerTop, String menuTopName, boolean isMenuTopSelected, String headerBottom, String menuBottomName, boolean isMenuBottomSelected, boolean useSmallTopMenu) {
        super(menuTopName, isMenuTopSelected, null, null, null, false);
        this.headerTop = headerTop;
        this.headerBottom = headerBottom;
        this.menuBottomName = menuBottomName;
        this.isMenuBottomSelected = isMenuBottomSelected;
        this.useSmallTopMenu = useSmallTopMenu;
    }

    @Override
    public void draw(IGraphicsContext gc, double left, double width, double height, PushConfiguration configuration) {
        boolean hasBottomHeader;
        double menuHeight = 34.66666666666667;
        if (this.useSmallTopMenu) {
            this.drawMenu(gc, left, width, configuration);
        } else {
            OptionsGridElement.drawLargeMenu(gc, left, 0.0, width, 34.66666666666667, this.menuName, this.isMenuSelected, configuration);
        }
        OptionsGridElement.drawLargeMenu(gc, left, 125.33333333333333, width, 34.66666666666667, this.menuBottomName, this.isMenuBottomSelected, configuration);
        boolean hasTopHeader = this.headerTop != null && this.headerTop.length() > 0;
        boolean bl = hasBottomHeader = this.headerBottom != null && this.headerBottom.length() > 0;
        if (!hasTopHeader && !hasBottomHeader) {
            return;
        }
        double headerHeight = 45.33333333333333;
        ColorEx textColor = configuration.getColorText();
        if (hasTopHeader) {
            gc.drawTextInHeight(this.headerTop, left, 34.66666666666667, 45.33333333333333, textColor, 22.666666666666664);
        }
        if (hasBottomHeader) {
            gc.drawTextInHeight(this.headerBottom, left, 80.0, 45.33333333333333, textColor, 22.666666666666664);
        }
    }

    protected static void drawLargeMenu(IGraphicsContext gc, double left, double top, double width, double height, String menu, boolean isSelected, PushConfiguration configuration) {
        if (menu == null || menu.length() == 0) {
            return;
        }
        ColorEx textColor = configuration.getColorText();
        gc.fillRectangle(left, top, width, height, isSelected ? textColor : configuration.getColorBackground());
        gc.drawTextInBounds(menu, left, top, width, height, Align.CENTER, isSelected ? configuration.getColorBorder() : textColor, height / 2.0);
    }
}

