/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display.model.grid;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.display.model.grid.AbstractGridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.StringUtils;

public class MidiClipElement
extends AbstractGridElement {
    private final ICursorClip clip;
    private int quartersPerMeasure;

    public MidiClipElement(ICursorClip clip, int quartersPerMeasure) {
        super(null, false, null, null, null, false);
        this.clip = clip;
        this.quartersPerMeasure = quartersPerMeasure;
    }

    @Override
    public void draw(IGraphicsContext gc, double left, double width, double height, PushConfiguration configuration) {
        double playEnd;
        double x;
        double end;
        double start;
        int top = 14;
        double noteAreaHeight = height - 14.0;
        gc.fillRectangle(left, 14.0, width, noteAreaHeight, ColorEx.fromRGB(168, 168, 168));
        int numSteps = this.clip.getNumSteps();
        double stepLength = this.clip.getStepLength();
        double pageLength = (double)numSteps * stepLength;
        int editPage = this.clip.getEditPage();
        double startPos = (double)editPage * pageLength;
        double endPos = (double)(editPage + 1) * pageLength;
        int len = 13;
        if (this.clip.isLoopEnabled()) {
            double loopStart = this.clip.getLoopStart();
            double loopLength = this.clip.getLoopLength();
            if (loopStart < endPos && loopStart + loopLength > startPos) {
                start = Math.max(0.0, loopStart - startPos);
                end = Math.min(endPos, loopStart + loopLength) - startPos;
                x = width * start / pageLength;
                double w = width * end / pageLength - x;
                gc.fillRectangle(x + 1.0, 0.0, w, 13.0, ColorEx.fromRGB(84, 84, 84));
                gc.fillRectangle(x + 1.0, 14.0, w, noteAreaHeight, ColorEx.fromRGB(181, 181, 181));
            }
        }
        double[] clipColor = this.clip.getColor();
        double playStart = this.clip.getPlayStart();
        ColorEx lineColor = new ColorEx(clipColor[0], clipColor[1], clipColor[2]);
        if (playStart >= startPos && playStart <= endPos) {
            start = playStart - startPos;
            double x2 = width * start / pageLength;
            gc.fillTriangle(x2 + 1.0, 0.0, x2 + 1.0 + 13.0, 6.0, x2 + 1.0, 13.0, lineColor);
        }
        if ((playEnd = this.clip.getPlayEnd()) >= startPos && playEnd <= endPos) {
            end = playEnd - startPos;
            x = width * end / pageLength;
            gc.fillTriangle(x + 1.0, 0.0, x + 1.0, 13.0, x + 1.0 - 14.0, 6.0, lineColor);
        }
        double stepWidth = width / (double)numSteps;
        for (int step = 0; step <= numSteps; ++step) {
            double x3 = left + (double)step * stepWidth;
            gc.fillRectangle(x3, 14.0, 1.0, noteAreaHeight, ColorEx.fromRGB(130, 130, 130));
            if (step % 4 != 0) continue;
            double time = startPos + (double)step * stepLength;
            String measureText = StringUtils.formatMeasures(this.quartersPerMeasure, time, 1);
            gc.drawTextInHeight(measureText, x3, 0.0, 13.0, ColorEx.WHITE, 14.0);
        }
        int lowerRowWithData = this.clip.getLowerRowWithData();
        if (lowerRowWithData == -1) {
            return;
        }
        int upperRowWithData = this.clip.getUpperRowWithData();
        int range = 1 + upperRowWithData - lowerRowWithData;
        double stepHeight = noteAreaHeight / (double)range;
        double fontSize = gc.calculateFontSize(stepHeight, stepWidth);
        for (int row = 0; row < range; ++row) {
            gc.fillRectangle(left, 14.0 + (double)(range - row - 1) * stepHeight, width, 1.0, ColorEx.fromRGB(130, 130, 130));
            for (int step = 0; step < numSteps; ++step) {
                boolean isStart;
                int note = lowerRowWithData + row;
                int stepState = this.clip.getStep(step, note);
                if (stepState == 0) continue;
                double x4 = left + (double)step * stepWidth - 1.0;
                double w = stepWidth + 2.0;
                boolean bl = isStart = stepState == 2;
                if (isStart) {
                    x4 += 2.0;
                    w -= 2.0;
                }
                gc.strokeRectangle(x4, 14.0 + (double)(range - row - 1) * stepHeight + 2.0, w, stepHeight - 2.0, ColorEx.BLACK);
                gc.fillRectangle(x4 + (double)(isStart ? 0 : -2), 14.0 + (double)(range - row - 1) * stepHeight + 2.0, w - 1.0 + (double)(isStart ? 0 : 2), stepHeight - 3.0, new ColorEx(clipColor[0], clipColor[1], clipColor[2]));
                if (!isStart || !(fontSize > 0.0)) continue;
                String text = Scales.formatDrumNote(note);
                gc.drawTextInBounds(text, x4, 14.0 + (double)(range - row - 1) * stepHeight + 2.0, w - 1.0, stepHeight - 3.0, Align.CENTER, ColorEx.BLACK, fontSize);
            }
        }
        int playStep = this.clip.getCurrentStep();
        if (playStep >= 0) {
            gc.fillRectangle(left + (double)playStep * stepWidth, 0.0, 1.0, height, ColorEx.BLACK);
        }
    }
}

