/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display.model.grid;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.display.model.grid.AbstractGridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.List;

public class ListGridElement
extends AbstractGridElement {
    private final List<Pair<String, Boolean>> items = new ArrayList<Pair<String, Boolean>>(6);

    public ListGridElement(List<Pair<String, Boolean>> items) {
        super(null, false, null, null, null, false);
        this.items.addAll(items);
    }

    @Override
    public void draw(IGraphicsContext gc, double left, double width, double height, PushConfiguration configuration) {
        int size = this.items.size();
        double itemHeight = 160.0 / (double)size;
        ColorEx textColor = configuration.getColorText();
        ColorEx borderColor = configuration.getColorBorder();
        for (int i = 0; i < size; ++i) {
            Pair<String, Boolean> item = this.items.get(i);
            boolean isSelected = item.getValue();
            double itemLeft = left + 2.0;
            double itemTop = (double)i * itemHeight;
            double itemWidth = width - 2.0;
            gc.fillRectangle(itemLeft, itemTop + 2.0, itemWidth, itemHeight - 4.0, isSelected ? textColor : borderColor);
            gc.drawTextInBounds(item.getKey(), itemLeft + 7.666666666666667, itemTop, itemWidth - 15.333333333333334, itemHeight, Align.LEFT, isSelected ? borderColor : textColor, itemHeight / 2.0);
        }
    }
}

