/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display.model.grid;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.display.model.grid.AbstractGridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.daw.resource.ResourceHandler;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IImage;
import java.util.EnumMap;

public class ChannelSelectionGridElement
extends AbstractGridElement {
    private static final EnumMap<ChannelType, String> ICONS = new EnumMap(ChannelType.class);
    protected static final int TRACK_ROW_HEIGHT = 21;
    private final ChannelType type;

    public ChannelSelectionGridElement(String menuName, boolean isMenuSelected, String name, ColorEx color, boolean isSelected, ChannelType type) {
        super(menuName, isMenuSelected, null, name, color, isSelected);
        this.type = type;
    }

    public ChannelType getType() {
        return this.type;
    }

    @Override
    public String getIcon() {
        return this.type == null ? null : ICONS.get((Object)this.type);
    }

    @Override
    public void draw(IGraphicsContext gc, double left, double width, double height, PushConfiguration configuration) {
        this.drawMenu(gc, left, width, configuration);
        String name = this.getName();
        if (name == null || name.length() == 0) {
            return;
        }
        double trackRowTop = height - 21.0 - 13.333333333333334 - 2.0;
        this.drawTrackInfo(gc, left, width, height, trackRowTop, name, configuration);
    }

    protected void drawTrackInfo(IGraphicsContext gc, double left, double width, double height, double trackRowTop, String name, PushConfiguration configuration) {
        ColorEx backgroundColor = configuration.getColorBackground();
        gc.fillRectangle(left, trackRowTop + 1.0, width, height - 13.333333333333334 - 1.0, this.isSelected() ? configuration.getColorBackgroundLighter() : backgroundColor);
        String iconName = this.getIcon();
        if (iconName != null) {
            IImage icon = ResourceHandler.getSVGImage(iconName);
            ColorEx maskColor = this.getMaskColor(configuration);
            if (maskColor == null) {
                gc.drawImage(icon, left + (26.666666666666668 - icon.getWidth()) / 2.0, height - 21.0 - 13.333333333333334 + (double)(21 - icon.getHeight()) / 2.0);
            } else {
                gc.maskImage(icon, left + (26.666666666666668 - icon.getWidth()) / 2.0, height - 21.0 - 13.333333333333334 + (double)(21 - icon.getHeight()) / 2.0, maskColor);
            }
        }
        gc.drawTextInBounds(name, left + 26.666666666666668, height - 21.0 - 13.333333333333334, width - 26.666666666666668, 21.0, Align.LEFT, configuration.getColorText(), 16.0);
        gc.fillRectangle(left, height - 13.333333333333334, width, 13.333333333333334, this.getColor());
    }

    protected ColorEx getMaskColor(PushConfiguration configuration) {
        return configuration.getColorText();
    }

    static {
        ICONS.put(ChannelType.AUDIO, "track/audio_track.svg");
        ICONS.put(ChannelType.INSTRUMENT, "track/instrument_track.svg");
        ICONS.put(ChannelType.GROUP, "track/group_track.svg");
        ICONS.put(ChannelType.EFFECT, "track/return_track.svg");
        ICONS.put(ChannelType.HYBRID, "track/hybrid_track.svg");
        ICONS.put(ChannelType.MASTER, "track/master_track.svg");
        ICONS.put(ChannelType.LAYER, "track/multi_layer.svg");
    }
}

