/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display.model.grid;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.display.model.grid.ChannelSelectionGridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.daw.resource.ResourceHandler;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IImage;

public class ChannelGridElement
extends ChannelSelectionGridElement {
    public static final int EDIT_TYPE_VOLUME = 0;
    public static final int EDIT_TYPE_PAN = 1;
    public static final int EDIT_TYPE_CROSSFADER = 2;
    public static final int EDIT_TYPE_ALL = 3;
    private final double editType;
    private final double volumeValue;
    private final double modulatedVolumeValue;
    private final String volumeText;
    private final double panValue;
    private final double modulatedPanValue;
    private final String panText;
    private final double vuValue;
    private final boolean isMute;
    private final boolean isSolo;
    private final boolean isArm;
    private final double crossfadeMode;

    public ChannelGridElement(double editType, String menuName, boolean isMenuSelected, String name, ColorEx color, boolean isSelected, ChannelType type, double volumeValue, double modulatedVolumeValue, String volumeText, double panValue, double modulatedPanValue, String panText, double vuValue, boolean isMute, boolean isSolo, boolean isArm, double crossfadeMode) {
        super(menuName, isMenuSelected, name, color, isSelected, type);
        this.editType = editType;
        this.volumeValue = volumeValue;
        this.modulatedVolumeValue = modulatedVolumeValue;
        this.volumeText = volumeText;
        this.panValue = panValue;
        this.modulatedPanValue = modulatedPanValue;
        this.panText = panText;
        this.vuValue = vuValue;
        this.isMute = isMute;
        this.isSolo = isSolo;
        this.isArm = isArm;
        this.crossfadeMode = crossfadeMode;
    }

    @Override
    public void draw(IGraphicsContext gc, double left, double width, double height, PushConfiguration configuration) {
        boolean isVolumeTouched;
        boolean isVolumeModulated;
        boolean isPanModulated;
        double halfWidth = width / 2.0;
        double trackRowTop = height - 21.0 - 13.333333333333334 - 2.0;
        double controlWidth = halfWidth - 6.666666666666667 - 3.3333333333333335;
        double controlStart = left + halfWidth + 6.666666666666667 - 3.3333333333333335;
        double panWidth = controlWidth - 2.0;
        double panStart = controlStart + 1.0;
        double panTop = 26.000000000000004;
        double panHeight = 11.333333333333334;
        double panTextTop = 37.333333333333336;
        double faderOffset = controlWidth / 4.0;
        double faderTop = 40.333333333333336;
        double faderLeft = controlStart + 2.0 + faderOffset;
        double faderHeight = trackRowTop - 40.333333333333336 - 7.666666666666667 + 1.0;
        double faderInnerHeight = faderHeight - 4.0;
        double volumeTextWidth = 1.4 * controlWidth;
        double volumeTextLeft = faderLeft - volumeTextWidth - 2.0;
        double buttonHeight = (faderHeight - 8.0) / 3.0;
        ColorEx textColor = configuration.getColorText();
        this.drawMenu(gc, left, width, configuration);
        String name = this.getName();
        if (name == null || name.length() == 0) {
            return;
        }
        ColorEx backgroundColor = configuration.getColorBackground();
        this.drawTrackInfo(gc, left, width, height, trackRowTop, name, configuration);
        gc.fillRectangle(left, 18.333333333333336, width, trackRowTop - 18.333333333333336, this.isSelected() ? configuration.getColorBackgroundLighter() : backgroundColor);
        ColorEx borderColor = configuration.getColorBorder();
        gc.fillRectangle(controlStart, 25.000000000000004, halfWidth - 13.333333333333334 + 3.3333333333333335, 13.333333333333334, borderColor);
        gc.fillRectangle(controlStart, 40.333333333333336, controlWidth, faderHeight, borderColor);
        ColorEx backgroundDarker = configuration.getColorBackgroundDarker();
        ColorEx editColor = configuration.getColorEdit();
        ChannelType type = this.getType();
        if (type != ChannelType.MASTER && type != ChannelType.LAYER && this.crossfadeMode != -1.0) {
            double crossWidth = controlWidth / 3.0;
            ColorEx selColor = this.editType == 2.0 || this.editType == 3.0 ? editColor : textColor;
            IImage crossfaderAIcon = ResourceHandler.getSVGImage("track/crossfade_a.svg");
            gc.maskImage(crossfaderAIcon, left + 7.666666666666667 + (crossWidth - crossfaderAIcon.getWidth()) / 2.0, 25.000000000000004 + (11.333333333333334 - (double)crossfaderAIcon.getHeight()) / 2.0, this.crossfadeMode == 0.0 ? selColor : backgroundDarker);
            IImage crossfaderABIcon = ResourceHandler.getSVGImage("track/crossfade_ab.svg");
            gc.maskImage(crossfaderABIcon, crossWidth + left + 7.666666666666667 + (crossWidth - crossfaderAIcon.getWidth()) / 2.0, 25.000000000000004 + (11.333333333333334 - (double)crossfaderAIcon.getHeight()) / 2.0, this.crossfadeMode == 1.0 ? selColor : backgroundDarker);
            IImage crossfaderBIcon = ResourceHandler.getSVGImage("track/crossfade_b.svg");
            gc.maskImage(crossfaderBIcon, 2.0 * crossWidth + left + 7.666666666666667 + (crossWidth - crossfaderAIcon.getWidth()) / 2.0, 25.000000000000004 + (11.333333333333334 - (double)crossfaderAIcon.getHeight()) / 2.0, this.crossfadeMode == 2.0 ? selColor : backgroundDarker);
        }
        gc.fillRectangle(panStart, 26.000000000000004, panWidth, 11.333333333333334, backgroundDarker);
        double panRange = panWidth / 2.0;
        double panMiddle = panStart + panRange;
        gc.drawLine(panMiddle, 26.000000000000004, panMiddle, 37.333333333333336, borderColor);
        double maxValue = ChannelGridElement.getMaxValue();
        double halfMax = maxValue / 2.0;
        boolean isPanTouched = this.panText.length() > 0;
        boolean isRight = this.panValue > halfMax;
        boolean isModulatedRight = this.modulatedPanValue > halfMax;
        double v = isRight ? (this.panValue - halfMax) * panRange / halfMax : panRange - this.panValue * panRange / halfMax;
        boolean bl = isPanModulated = this.modulatedPanValue != -1.0;
        double vMod = isPanModulated ? (isModulatedRight ? (this.modulatedPanValue - halfMax) * panRange / halfMax : panRange - this.modulatedPanValue * panRange / halfMax) : v;
        ColorEx faderColor = configuration.getColorFader();
        gc.fillRectangle((isPanModulated ? isModulatedRight : isRight) ? panMiddle + 1.0 : panMiddle - vMod, 26.000000000000004, vMod, 11.333333333333334, faderColor);
        if (this.editType == 1.0 || this.editType == 3.0) {
            double w = isPanTouched ? 3.0 : 1.0;
            double start = isRight ? Math.min(panMiddle + panRange - w, panMiddle + v) : Math.max(panMiddle - panRange, panMiddle - v);
            gc.fillRectangle(start, 26.000000000000004, w, 11.333333333333334, editColor);
        }
        double volumeWidth = controlWidth - 4.0 - faderOffset;
        double volumeHeight = this.volumeValue >= maxValue - 1.0 ? faderInnerHeight : faderInnerHeight * this.volumeValue / maxValue;
        boolean bl2 = isVolumeModulated = this.modulatedVolumeValue != -1.0;
        double modulatedVolumeHeight = isVolumeModulated ? (this.modulatedVolumeValue >= maxValue - 1.0 ? faderInnerHeight : faderInnerHeight * this.modulatedVolumeValue / maxValue) : volumeHeight;
        double volumeTop = 42.333333333333336 + faderInnerHeight - volumeHeight;
        double modulatedVolumeTop = isVolumeModulated ? 42.333333333333336 + faderInnerHeight - modulatedVolumeHeight : volumeTop;
        gc.fillRectangle(faderLeft, modulatedVolumeTop, volumeWidth, modulatedVolumeHeight, faderColor);
        boolean bl3 = isVolumeTouched = this.volumeText.length() > 0;
        if (this.editType == 0.0 || this.editType == 3.0) {
            double h = isVolumeTouched ? 3.0 : 1.0;
            gc.fillRectangle(faderLeft, Math.min(volumeTop + volumeHeight - h, volumeTop), volumeWidth, h, editColor);
        }
        double vuHeight = this.vuValue >= maxValue - 1.0 ? faderInnerHeight : faderInnerHeight * this.vuValue / maxValue;
        double vuOffset = faderInnerHeight - vuHeight;
        gc.fillRectangle(controlStart + 2.0, 42.333333333333336, faderOffset - 2.0, faderInnerHeight, backgroundDarker);
        gc.fillRectangle(controlStart + 2.0, 42.333333333333336 + vuOffset, faderOffset - 2.0, vuHeight, configuration.getColorVu());
        double buttonTop = 40.333333333333336;
        if (type != ChannelType.LAYER) {
            ChannelGridElement.drawButton(gc, left + 7.666666666666667 - 1.0, buttonTop, controlWidth - 1.0, buttonHeight - 1.0, backgroundColor, configuration.getColorRecord(), textColor, this.isArm, "channel/record_arm.svg", configuration);
        }
        ChannelGridElement.drawButton(gc, left + 7.666666666666667 - 1.0, buttonTop += buttonHeight + 4.0, controlWidth - 1.0, buttonHeight - 1.0, backgroundColor, configuration.getColorSolo(), textColor, this.isSolo, "channel/solo.svg", configuration);
        ChannelGridElement.drawButton(gc, left + 7.666666666666667 - 1.0, buttonTop += buttonHeight + 4.0, controlWidth - 1.0, buttonHeight - 1.0, backgroundColor, configuration.getColorMute(), textColor, this.isMute, "channel/mute.svg", configuration);
        if (isPanTouched) {
            gc.fillRectangle(controlStart, 37.333333333333336, controlWidth, 13.333333333333334, backgroundDarker);
            gc.strokeRectangle(controlStart, 37.333333333333336, controlWidth - 1.0, 13.333333333333334, borderColor);
            gc.drawTextInBounds(this.panText, controlStart, 37.333333333333336, controlWidth, 13.333333333333334, Align.CENTER, textColor, 13.333333333333334);
        }
        if (isVolumeTouched) {
            double volumeTextTop = this.volumeValue >= maxValue - 1.0 ? 40.333333333333336 : Math.min(volumeTop - 1.0, 40.333333333333336 + faderInnerHeight + 2.0 - 13.333333333333334 + 1.0);
            gc.fillRectangle(volumeTextLeft, volumeTextTop, volumeTextWidth, 13.333333333333334, backgroundDarker);
            gc.strokeRectangle(volumeTextLeft, volumeTextTop, volumeTextWidth - 1.0, 13.333333333333334, borderColor);
            gc.drawTextInBounds(this.volumeText, volumeTextLeft, volumeTextTop, volumeTextWidth, 13.333333333333334, Align.CENTER, textColor, 13.333333333333334);
        }
    }

    private static void drawButton(IGraphicsContext gc, double left, double top, double width, double height, ColorEx backgroundColor, ColorEx isOnColor, ColorEx textColor, boolean isOn, String iconName, PushConfiguration configuration) {
        ColorEx borderColor = configuration.getColorBorder();
        double radius = 2.0;
        gc.fillRoundedRectangle(left, top, width, height, 2.0, borderColor);
        if (isOn) {
            gc.fillRoundedRectangle(left + 1.0, top + 1.0, width - 2.0, height - 2.0, 2.0, isOnColor);
        } else {
            gc.fillGradientRoundedRectangle(left + 1.0, top + 1.0, width - 2.0, height - 2.0, 2.0, backgroundColor, ColorEx.brighter(backgroundColor));
        }
        IImage icon = ResourceHandler.getSVGImage(iconName);
        gc.maskImage(icon, left + (width - icon.getWidth()) / 2.0, top + (height - (double)icon.getHeight()) / 2.0, isOn ? borderColor : textColor);
    }
}

