/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display.model.grid;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.display.model.grid.AbstractGridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import java.util.ArrayList;
import java.util.List;

public class BoxListGridElement
extends AbstractGridElement {
    private String[] items;
    private List<ColorEx> colors = new ArrayList<ColorEx>();

    public BoxListGridElement(String[] items, List<double[]> colors) {
        super(null, false, null, null, null, false);
        this.items = items;
        for (double[] color : colors) {
            this.colors.add(new ColorEx(color[0], color[1], color[2]));
        }
    }

    @Override
    public void draw(IGraphicsContext gc, double left, double width, double height, PushConfiguration configuration) {
        int size = this.items.length;
        double itemHeight = 160.0 / (double)size;
        ColorEx textColor = configuration.getColorText();
        ColorEx borderColor = configuration.getColorBackgroundLighter();
        for (int i = 0; i < size; ++i) {
            double itemLeft = left + 2.0;
            double itemTop = (double)i * itemHeight;
            double itemWidth = width - 2.0;
            gc.fillRectangle(itemLeft, itemTop + 2.0, itemWidth, itemHeight - 4.0, this.colors.get(i));
            gc.strokeRectangle(itemLeft, itemTop + 2.0, itemWidth, itemHeight - 4.0, borderColor);
            gc.drawTextInBounds(this.items[i], itemLeft + 7.666666666666667, itemTop - 1.0, itemWidth - 15.333333333333334, itemHeight, Align.LEFT, textColor, itemHeight / 2.0);
        }
    }
}

