/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display.model.grid;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.display.model.grid.GridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;

public abstract class AbstractGridElement
implements GridElement {
    private static double maxValue = 1024.0;
    private final String name;
    private final String icon;
    private final ColorEx color;
    private final boolean isSelected;
    protected final boolean isMenuSelected;
    protected final String menuName;

    public AbstractGridElement(String menuName, boolean isMenuSelected, String icon, String name, ColorEx color, boolean isSelected) {
        this.name = name;
        this.icon = icon;
        this.color = color;
        this.isSelected = isSelected;
        this.menuName = menuName;
        this.isMenuSelected = isMenuSelected;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public ColorEx getColor() {
        return this.color;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected void drawMenu(IGraphicsContext gc, double left, double width, PushConfiguration configuration) {
        ColorEx borderColor = configuration.getColorBorder();
        if (this.menuName == null || this.menuName.length() == 0) {
            gc.fillRectangle(left - 2.0, 15.333333333333336, 2.0, 1.0, borderColor);
            return;
        }
        ColorEx textColor = configuration.getColorText();
        gc.fillRectangle(left, 0.0, width, 16.333333333333336, this.isMenuSelected ? textColor : borderColor);
        gc.fillRectangle(left, 15.333333333333336, width + 2.0, 1.0, textColor);
        gc.drawTextInBounds(this.menuName, left, 1.0, width, 15.333333333333334, Align.CENTER, this.isMenuSelected ? borderColor : textColor, 13.333333333333334);
    }

    public static double getMaxValue() {
        return maxValue;
    }

    public static void setMaxValue(double maxValue) {
        AbstractGridElement.maxValue = maxValue;
    }
}

