/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display.model;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.display.model.DisplayModel;
import de.mossgrabers.controller.push.controller.display.model.grid.GridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.resource.ResourceHandler;
import de.mossgrabers.framework.graphics.IBitmap;
import java.util.List;

public class VirtualDisplay {
    private static final int DISPLAY_WIDTH = 960;
    private static final int DISPLAY_HEIGHT = 160;
    private final DisplayModel model;
    private final IBitmap image;
    private final PushConfiguration configuration;

    public VirtualDisplay(IHost host, DisplayModel model, PushConfiguration configuration) {
        this.model = model;
        ResourceHandler.init(host);
        this.image = host.createBitmap(960, 160);
        this.image.setDisplayWindowTitle("Push 2 Display");
        this.model.addGridElementChangeListener(this::redrawGrid);
        this.configuration = configuration;
    }

    public void redrawGrid() {
        this.drawGrid(this.image);
    }

    public IBitmap getImage() {
        return this.image;
    }

    private void drawGrid(IBitmap bitmap) {
        bitmap.render(gc -> {
            ColorEx colorBorder = this.configuration.getColorBorder();
            gc.fillRectangle(0.0, 0.0, 960.0, 160.0, colorBorder);
            List<GridElement> elements = this.model.getGridElements();
            int size = elements.size();
            if (size == 0) {
                return;
            }
            int gridWidth = 960 / size;
            double paintWidth = (double)gridWidth - 2.0;
            double offsetX = 1.0;
            for (int i = 0; i < size; ++i) {
                elements.get(i).draw(gc, (double)(i * gridWidth) + 1.0, paintWidth, 160.0, this.configuration);
            }
        });
    }
}

