/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller.display;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMemoryBlock;
import de.mossgrabers.framework.graphics.IBitmap;
import de.mossgrabers.framework.usb.IUSBDevice;
import de.mossgrabers.framework.usb.IUSBEndpoint;

public class PushUSBDisplay {
    private static final int DATA_SZ = 327680;
    private static final int TIMEOUT = 1000;
    private static final byte[] DISPLAY_HEADER = new byte[]{-17, -51, -85, -119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private IUSBDevice usbDevice;
    private IUSBEndpoint usbEndpoint;
    private final IMemoryBlock headerBlock;
    private final IMemoryBlock imageBlock;
    private boolean isSending = false;

    public PushUSBDisplay(IHost host) {
        try {
            this.usbDevice = host.getUsbDevice(0);
            this.usbEndpoint = this.usbDevice.getEndpoint(0, 0);
        }
        catch (RuntimeException ex) {
            this.usbDevice = null;
            this.usbEndpoint = null;
            host.error("Could not open USB output.");
        }
        this.headerBlock = host.createMemoryBlock(DISPLAY_HEADER.length);
        this.headerBlock.createByteBuffer().put(DISPLAY_HEADER);
        this.imageBlock = host.createMemoryBlock(327680);
    }

    public void send(IBitmap image) {
        if (this.usbDevice == null || this.usbEndpoint == null || this.isSending) {
            return;
        }
        this.isSending = true;
        image.fillTransferBuffer(this.imageBlock.createByteBuffer());
        this.usbEndpoint.send(this.headerBlock, 1000);
        this.usbEndpoint.send(this.imageBlock, 1000);
        this.isSending = false;
    }

    public void shutdown() {
        this.usbDevice = null;
        this.usbEndpoint = null;
    }
}

