/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.DisplayMessage;
import de.mossgrabers.controller.push.controller.display.PushUSBDisplay;
import de.mossgrabers.controller.push.controller.display.model.DisplayModel;
import de.mossgrabers.controller.push.controller.display.model.VirtualDisplay;
import de.mossgrabers.controller.push.controller.display.model.grid.GridChangeListener;
import de.mossgrabers.framework.controller.display.AbstractDisplay;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class PushDisplay
extends AbstractDisplay
implements GridChangeListener {
    public static final String BARS_NON = Character.toString('\u0006');
    public static final String BARS_ONE = Character.toString('\u0003');
    public static final String BARS_TWO = Character.toString('\u0005');
    private static final String BARS_ONE_L = Character.toString('\u0004');
    private static final String NON_4 = BARS_NON + BARS_NON + BARS_NON + BARS_NON;
    public static final String RIGHT_ARROW = Character.toString('\u007f');
    private static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             "};
    private static final String[] DASHES = new String[]{"", BARS_NON, BARS_NON + BARS_NON, BARS_NON + BARS_NON + BARS_NON, BARS_NON + BARS_NON + BARS_NON + BARS_NON, BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON, BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON, BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON, BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON, BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON + BARS_NON};
    private static final String[] SYSEX_MESSAGE = new String[]{"F0 47 7F 15 18 00 45 00 ", "F0 47 7F 15 19 00 45 00 ", "F0 47 7F 15 1A 00 45 00 ", "F0 47 7F 15 1B 00 45 00 "};
    private int maxParameterValue;
    private boolean isPush2;
    private DisplayModel model;
    private final VirtualDisplay virtualDisplay;
    private final PushUSBDisplay usbDisplay;

    public PushDisplay(IHost host, boolean isPush2, int maxParameterValue, IMidiOutput output, PushConfiguration configuration) {
        super(host, output, 4, 8, 68);
        this.maxParameterValue = maxParameterValue;
        this.isPush2 = isPush2;
        this.model = new DisplayModel();
        this.model.addGridElementChangeListener(this);
        this.virtualDisplay = this.isPush2 ? new VirtualDisplay(host, this.model, configuration) : null;
        this.usbDisplay = this.isPush2 ? new PushUSBDisplay(host) : null;
    }

    public DisplayMessage createMessage() {
        return new DisplayMessage(this.model);
    }

    public void send(DisplayMessage message) {
        message.send();
    }

    @Override
    public void shutdown() {
        if (this.isPush2) {
            this.send(this.createMessage().setMessage(3, "Please start " + this.host.getName() + " to play..."));
            if (this.usbDisplay != null) {
                this.usbDisplay.shutdown();
            }
        } else {
            this.clear().setBlock(1, 1, "     Please start").setBlock(1, 2, this.host.getName() + " to play...").allDone().flush();
        }
    }

    @Override
    public PushDisplay clearCell(int row, int cell) {
        this.cells[row * 8 + cell] = cell % 2 == 0 ? "         " : "        ";
        return this;
    }

    @Override
    public PushDisplay setBlock(int row, int block, String value) {
        int cell = 2 * block;
        if (value.length() > 9) {
            this.cells[row * 8 + cell] = value.substring(0, 9);
            this.cells[row * 8 + cell + 1] = PushDisplay.pad(value.substring(9), 8, " ");
        } else {
            this.cells[row * 8 + cell] = PushDisplay.pad(value, 9, " ");
            this.clearCell(row, cell + 1);
        }
        return this;
    }

    @Override
    public PushDisplay setCell(int row, int cell, int value, Format format) {
        return this.setCell(row, cell, PushDisplay.formatStr(value, format, this.maxParameterValue));
    }

    @Override
    public PushDisplay setCell(int row, int cell, String value) {
        this.cells[row * 8 + cell] = PushDisplay.pad(value, 8, " ") + (cell % 2 == 0 ? " " : "");
        return this;
    }

    @Override
    public void writeLine(int row, String text) {
        int[] array = new int[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            array[i] = text.charAt(i);
        }
        this.output.sendSysex(SYSEX_MESSAGE[row] + PushDisplay.toHexStr(array) + "F7");
    }

    @Override
    protected void notifyOnDisplay(String message) {
        if (this.isPush2) {
            this.send(this.createMessage().setMessage(3, message));
        } else {
            super.notifyOnDisplay(message);
        }
    }

    private static String formatStr(int value, Format format, int maxParam) {
        switch (format) {
            case FORMAT_VALUE: {
                return PushDisplay.formatValue(value, maxParam);
            }
            case FORMAT_PAN: {
                return PushDisplay.formatPan(value, maxParam);
            }
        }
        return Integer.toString(value);
    }

    private static String formatValue(int value, int maxParam) {
        int noOfBars = (int)Math.round(16.0 * (double)value / (double)maxParam);
        StringBuilder n = new StringBuilder();
        for (int j = 0; j < noOfBars / 2; ++j) {
            n.append(BARS_TWO);
        }
        if (noOfBars % 2 == 1) {
            n.append(BARS_ONE);
        }
        return PushDisplay.pad(n.toString(), 8, BARS_NON);
    }

    private static String formatPan(int pan, int maxParam) {
        int middle = maxParam / 2;
        if (pan == middle) {
            return NON_4 + NON_4;
        }
        boolean isLeft = pan < middle;
        int pos = isLeft ? middle - pan : pan - middle;
        int noOfBars = 16 * pos / maxParam;
        StringBuilder n = new StringBuilder();
        for (int i = 0; i < noOfBars / 2; ++i) {
            n.append(BARS_TWO);
        }
        if (noOfBars % 2 == 1) {
            n.append(isLeft ? BARS_ONE_L : BARS_ONE);
        }
        n = new StringBuilder(NON_4).append(PushDisplay.pad(n.toString(), 4, BARS_NON));
        return isLeft ? n.reverse().toString() : n.toString();
    }

    public static String pad(String str, int length, String character) {
        String text = str == null ? "" : str;
        int diff = length - text.length();
        if (diff < 0) {
            return text.substring(0, length);
        }
        if (diff > 0) {
            return text + (" ".equals(character) ? SPACES[diff] : DASHES[diff]);
        }
        return text;
    }

    private static String toHexStr(int[] data) {
        StringBuilder sysex = new StringBuilder();
        for (int d : data) {
            String v = Integer.toHexString(d).toUpperCase();
            if (v.length() < 2) {
                sysex.append('0');
            }
            sysex.append(v).append(' ');
        }
        return sysex.toString();
    }

    public void showDebugWindow() {
        if (this.virtualDisplay != null) {
            this.virtualDisplay.getImage().showDisplayWindow();
        }
    }

    @Override
    public void gridHasChanged() {
        if (this.usbDisplay != null) {
            this.usbDisplay.send(this.virtualDisplay.getImage());
        }
    }
}

