/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;

public class PushControlSurface
extends AbstractControlSurface<PushConfiguration> {
    private static final int PUSH1_IDENTITY_MIN_LENGTH = 35;
    private static final int[] PUSH1_ID = new int[]{240, 126, 0, 6, 2, 71, 21};
    private static final int PUSH2_IDENTITY_MIN_LENGTH = 21;
    private static final int[] PUSH2_ID = new int[]{240, 126, 1, 6, 2, 0};
    public static final String[] PUSH_PAD_CURVES_NAME = new String[]{"Linear", "Log 1 (Default)", "Log 2", "Log 3", "Log 4", "Log 5"};
    public static final String[] PUSH_PAD_THRESHOLDS_NAME = new String[]{"-20", "-19", "-18", "-17", "-16", "-15", "-14", "-13", "-12", "-11", "-10", "-9", "-8", "-7", "-6", "-5", "-4", "-3", "-2", "-1", "0 (Default)", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
    public static final int PUSH_BUTTON_TAP = 3;
    public static final int PUSH_BUTTON_METRONOME = 9;
    public static final int PUSH_SMALL_KNOB1 = 14;
    public static final int PUSH_SMALL_KNOB2 = 15;
    public static final int PUSH_BUTTON_ROW1_1 = 20;
    public static final int PUSH_BUTTON_ROW1_2 = 21;
    public static final int PUSH_BUTTON_ROW1_3 = 22;
    public static final int PUSH_BUTTON_ROW1_4 = 23;
    public static final int PUSH_BUTTON_ROW1_5 = 24;
    public static final int PUSH_BUTTON_ROW1_6 = 25;
    public static final int PUSH_BUTTON_ROW1_7 = 26;
    public static final int PUSH_BUTTON_ROW1_8 = 27;
    public static final int PUSH_BUTTON_MASTER = 28;
    public static final int PUSH_BUTTON_CLIP_STOP = 29;
    public static final int PUSH_BUTTON_SETUP = 30;
    public static final int PUSH_BUTTON_LAYOUT = 31;
    public static final int PUSH_BUTTON_CONVERT = 35;
    public static final int PUSH_BUTTON_SCENE1 = 36;
    public static final int PUSH_BUTTON_SCENE2 = 37;
    public static final int PUSH_BUTTON_SCENE3 = 38;
    public static final int PUSH_BUTTON_SCENE4 = 39;
    public static final int PUSH_BUTTON_SCENE5 = 40;
    public static final int PUSH_BUTTON_SCENE6 = 41;
    public static final int PUSH_BUTTON_SCENE7 = 42;
    public static final int PUSH_BUTTON_SCENE8 = 43;
    public static final int PUSH_BUTTON_LEFT = 44;
    public static final int PUSH_BUTTON_RIGHT = 45;
    public static final int PUSH_BUTTON_UP = 46;
    public static final int PUSH_BUTTON_DOWN = 47;
    public static final int PUSH_BUTTON_SELECT = 48;
    public static final int PUSH_BUTTON_SHIFT = 49;
    public static final int PUSH_BUTTON_NOTE = 50;
    public static final int PUSH_BUTTON_SESSION = 51;
    public static final int PUSH_BUTTON_ADD_EFFECT = 52;
    public static final int PUSH_BUTTON_ADD_TRACK = 53;
    public static final int PUSH_BUTTON_OCTAVE_DOWN = 54;
    public static final int PUSH_BUTTON_OCTAVE_UP = 55;
    public static final int PUSH_BUTTON_REPEAT = 56;
    public static final int PUSH_BUTTON_ACCENT = 57;
    public static final int PUSH_BUTTON_SCALES = 58;
    public static final int PUSH_BUTTON_USER_MODE = 59;
    public static final int PUSH_BUTTON_MUTE = 60;
    public static final int PUSH_BUTTON_SOLO = 61;
    public static final int PUSH_BUTTON_DEVICE_LEFT = 62;
    public static final int PUSH_BUTTON_DEVICE_RIGHT = 63;
    public static final int PUSH_FOOTSWITCH1 = 64;
    public static final int PUSH_FOOTSWITCH2 = 69;
    public static final int PUSH_KNOB1 = 71;
    public static final int PUSH_KNOB2 = 72;
    public static final int PUSH_KNOB3 = 73;
    public static final int PUSH_KNOB4 = 74;
    public static final int PUSH_KNOB5 = 75;
    public static final int PUSH_KNOB6 = 76;
    public static final int PUSH_KNOB7 = 77;
    public static final int PUSH_KNOB8 = 78;
    public static final int PUSH_KNOB9 = 79;
    public static final int PUSH_BUTTON_PLAY = 85;
    public static final int PUSH_BUTTON_RECORD = 86;
    public static final int PUSH_BUTTON_NEW = 87;
    public static final int PUSH_BUTTON_DUPLICATE = 88;
    public static final int PUSH_BUTTON_AUTOMATION = 89;
    public static final int PUSH_BUTTON_FIXED_LENGTH = 90;
    public static final int PUSH_BUTTON_ROW2_1 = 102;
    public static final int PUSH_BUTTON_ROW2_2 = 103;
    public static final int PUSH_BUTTON_ROW2_3 = 104;
    public static final int PUSH_BUTTON_ROW2_4 = 105;
    public static final int PUSH_BUTTON_ROW2_5 = 106;
    public static final int PUSH_BUTTON_ROW2_6 = 107;
    public static final int PUSH_BUTTON_ROW2_7 = 108;
    public static final int PUSH_BUTTON_ROW2_8 = 109;
    public static final int PUSH_BUTTON_DEVICE = 110;
    public static final int PUSH_BUTTON_BROWSE = 111;
    public static final int PUSH_BUTTON_TRACK = 112;
    public static final int PUSH_BUTTON_CLIP = 113;
    public static final int PUSH_BUTTON_VOLUME = 114;
    public static final int PUSH_BUTTON_PAN_SEND = 115;
    public static final int PUSH_BUTTON_QUANTIZE = 116;
    public static final int PUSH_BUTTON_DOUBLE = 117;
    public static final int PUSH_BUTTON_DELETE = 118;
    public static final int PUSH_BUTTON_UNDO = 119;
    public static final int PUSH_KNOB1_TOUCH = 0;
    public static final int PUSH_KNOB2_TOUCH = 1;
    public static final int PUSH_KNOB3_TOUCH = 2;
    public static final int PUSH_KNOB4_TOUCH = 3;
    public static final int PUSH_KNOB5_TOUCH = 4;
    public static final int PUSH_KNOB6_TOUCH = 5;
    public static final int PUSH_KNOB7_TOUCH = 6;
    public static final int PUSH_KNOB8_TOUCH = 7;
    public static final int PUSH_KNOB9_TOUCH = 8;
    public static final int PUSH_SMALL_KNOB1_TOUCH = 10;
    public static final int PUSH_SMALL_KNOB2_TOUCH = 9;
    private static final int[] PUSH_BUTTONS_ALL = new int[]{3, 9, 28, 29, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 85, 86, 87, 88, 89, 90, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 30, 31, 35, 36, 37, 38, 39, 40, 41, 42, 43, 20, 21, 22, 23, 24, 25, 26, 27, 102, 103, 104, 105, 106, 107, 108, 109};
    private static final boolean[] PUSH_BUTTON_UPDATE = new boolean[128];
    public static final int PUSH_RIBBON_TOUCH = 12;
    public static final int PUSH_RIBBON_PITCHBEND = 0;
    public static final int PUSH_RIBBON_VOLUME = 1;
    public static final int PUSH_RIBBON_PAN = 2;
    public static final int PUSH_RIBBON_DISCRETE = 3;
    private static final String[] PUSH_PAD_CURVES_DATA;
    private static final String[] PUSH_PAD_THRESHOLDS_DATA;
    private static final int[] MAXW;
    private static final int[] PUSH2_CPMIN;
    private static final int[] PUSH2_CPMAX;
    private static final double[] GAMMA;
    private static final int[] MINV;
    private static final int[] MAXV;
    private static final int[] ALPHA;
    private static final int PAD_VELOCITY_CURVE_CHUNK_SIZE = 16;
    private static final int NUM_VELOCITY_CURVE_ENTRIES = 128;
    private int ribbonMode = -1;
    private int ribbonValue = -1;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int buildNumber = -1;
    private int serialNumber = -1;
    private int boardRevision = -1;

    public PushControlSurface(IHost host, ColorManager colorManager, PushConfiguration configuration, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, output, input, PUSH_BUTTONS_ALL);
        this.selectButtonId = 48;
        this.shiftButtonId = 49;
        this.deleteButtonId = 118;
        this.soloButtonId = 61;
        this.muteButtonId = 60;
        this.leftButtonId = 44;
        this.rightButtonId = 45;
        this.upButtonId = 46;
        this.downButtonId = 47;
        this.pads = new PadGridImpl(colorManager, output);
        this.input.setSysexCallback(this::handleSysEx);
    }

    @Override
    public int getSceneButton(int index) {
        return 36 + index;
    }

    public String getSelectedPadThreshold() {
        return PUSH_PAD_THRESHOLDS_NAME[((PushConfiguration)this.configuration).getPadThreshold()];
    }

    public String getSelectedVelocityCurve() {
        return PUSH_PAD_CURVES_NAME[((PushConfiguration)this.configuration).getVelocityCurve()];
    }

    @Override
    public void shutdown() {
        int i;
        for (int button : this.getButtons()) {
            this.setButton(button, 0);
        }
        for (i = 20; i < 28; ++i) {
            this.setButton(i, 0);
        }
        for (i = 102; i < 110; ++i) {
            this.setButton(i, 0);
        }
        this.pads.turnOff();
        this.display.shutdown();
    }

    @Override
    public void setButton(int button, int state) {
        this.output.sendCC(button, state);
    }

    public void setRibbonMode(int mode) {
        if (this.ribbonMode == mode) {
            return;
        }
        this.ribbonMode = mode;
        if (((PushConfiguration)this.configuration).isPush2()) {
            int status = 0;
            switch (mode) {
                case 0: {
                    status = 122;
                    break;
                }
                case 1: {
                    status = 1;
                    break;
                }
                case 2: {
                    status = 17;
                    break;
                }
            }
            this.sendPush2SysEx(new int[]{23, status});
        } else {
            this.output.sendSysex("F0 47 7F 15 63 00 01 0" + mode + " F7");
        }
    }

    public void setRibbonValue(int value) {
        if (this.ribbonValue == value) {
            return;
        }
        this.ribbonValue = value;
        this.output.sendPitchbend(0, value);
    }

    public void sendPadSensitivity() {
        this.output.sendSysex("F0 47 7F 15 5D 00 20 " + PUSH_PAD_THRESHOLDS_DATA[((PushConfiguration)this.configuration).getPadThreshold()] + " " + PUSH_PAD_CURVES_DATA[((PushConfiguration)this.configuration).getVelocityCurve()] + " F7");
    }

    public void sendPressureMode(boolean isPolyPressure) {
        if (((PushConfiguration)this.configuration).isPush2()) {
            this.output.sendSysex("F0 00 21 1D 01 01 1E 0" + (isPolyPressure ? "1" : "0") + " F7");
        } else {
            this.output.sendSysex("F0 47 7F 15 5C 00 01 0" + (isPolyPressure ? "0" : "1") + " F7");
        }
    }

    public void sendPadVelocityCurve() {
        int[] velocities = PushControlSurface.generateVelocityCurve(((PushConfiguration)this.configuration).getPadSensitivity(), ((PushConfiguration)this.configuration).getPadGain(), ((PushConfiguration)this.configuration).getPadDynamics());
        for (int index = 0; index < velocities.length; index += 16) {
            int[] args = new int[18];
            args[0] = 32;
            args[1] = index;
            for (int i = 0; i < 16; ++i) {
                args[i + 2] = velocities[index + i];
            }
            this.sendPush2SysEx(args);
        }
    }

    private static int[] generateVelocityCurve(int sensitivity, int gain, int dynamics) {
        int minw = 160;
        int maxw = MAXW[sensitivity];
        int minv = MINV[gain];
        int maxv = MAXV[gain];
        double[] result = PushControlSurface.calculatePoints(ALPHA[dynamics]);
        double p1x = result[0];
        double p1y = result[1];
        double p2x = result[2];
        double p2y = result[3];
        int[] curve = new int[128];
        int minwIndex = 5;
        int maxwIndex = maxw / 32;
        double t = 0.0;
        for (int index = 0; index < 128; ++index) {
            double velocity;
            double w = (double)index * 32.0;
            if (w <= 160.0) {
                velocity = 1.0 + ((double)minv - 1.0) * (double)index / 5.0;
            } else if (w >= (double)maxw) {
                velocity = (double)maxv + (127.0 - (double)maxv) * (double)(index - maxwIndex) / (double)(128 - maxwIndex);
            } else {
                double wnorm = (w - 160.0) / (double)(maxw - 160);
                double[] bez = PushControlSurface.bezier(wnorm, t, p1x, p1y, p2x, p2y);
                double b = bez[0];
                t = bez[1];
                double velonorm = PushControlSurface.gammaFunc(b, GAMMA[gain]);
                velocity = (double)minv + velonorm * (double)(maxv - minv);
            }
            curve[index] = (int)Math.min(Math.max(Math.round(velocity), 1L), 127L);
        }
        return curve;
    }

    private static double[] bezier(double x, double t, double p1x, double p1y, double p2x, double p2y) {
        double tl;
        double p0x = 0.0;
        double p0y = 0.0;
        double p3x = 1.0;
        double p3y = 1.0;
        for (tl = t; tl <= 1.0; tl += 1.0E-4) {
            double s = 1.0 - tl;
            double s2 = s * s;
            double s3 = s2 * s;
            double t2 = tl * tl;
            double t3 = t2 * tl;
            double xt = s3 * 0.0 + 3.0 * tl * s2 * p1x + 3.0 * t2 * s * p2x + t3 * 1.0;
            if (!(xt >= x)) continue;
            return new double[]{s3 * 0.0 + 3.0 * tl * s2 * p1y + 3.0 * t2 * s * p2y + t3 * 1.0, tl};
        }
        return new double[]{1.0, tl};
    }

    private static double[] calculatePoints(double alpha) {
        double a1 = (225.0 - alpha) * Math.PI / 180.0;
        double a2 = (45.0 - alpha) * Math.PI / 180.0;
        double r = 0.4;
        return new double[]{0.5 + 0.4 * Math.cos(a1), 0.5 + 0.4 * Math.sin(a1), 0.5 + 0.4 * Math.cos(a2), 0.5 + 0.4 * Math.sin(a2)};
    }

    private static double gammaFunc(double x, double gamma) {
        return Math.pow(x, Math.exp(-4.0 + 8.0 * gamma));
    }

    public void sendPadThreshold() {
        int[] args = new int[9];
        args[0] = 27;
        PushControlSurface.add7L5M(args, 1, 33);
        PushControlSurface.add7L5M(args, 3, 31);
        int padSensitivity = ((PushConfiguration)this.configuration).getPadSensitivity();
        PushControlSurface.add7L5M(args, 5, PUSH2_CPMIN[padSensitivity]);
        PushControlSurface.add7L5M(args, 7, PUSH2_CPMAX[padSensitivity]);
        this.sendPush2SysEx(args);
    }

    private static void add7L5M(int[] array, int index, int value) {
        array[index] = value & 0x7F;
        array[index + 1] = value >> 7 & 0x1F;
    }

    public void sendDisplayBrightness() {
        int brightness = ((PushConfiguration)this.configuration).getDisplayBrightness() * 255 / 100;
        this.sendPush2SysEx(new int[]{8, brightness & 0x7F, brightness >> 7 & 1});
    }

    public void sendLEDBrightness() {
        int brightness = ((PushConfiguration)this.configuration).getLedBrightness() * 127 / 100;
        this.sendPush2SysEx(new int[]{6, brightness});
    }

    public void sendAftertouchMode(int mode) {
        this.sendPush2SysEx(new int[]{30, mode});
    }

    public void sendPush2SysEx(int[] parameters) {
        this.output.sendSysex("F0 00 21 1D 01 01 " + StringUtils.toHexStr(parameters) + "F7");
    }

    private void handleSysEx(String data) {
        if (((PushConfiguration)this.configuration).isPush2()) {
            int byteLength = data.length() / 2;
            if (byteLength < 21) {
                this.errorln("Wrong Push 2 identifier length " + byteLength + " but must be " + 21);
                this.errorln(data);
                return;
            }
            for (int i = 0; i < PUSH2_ID.length; ++i) {
                int value = PushControlSurface.hexByteAt(data, i);
                if (value == PUSH2_ID[i]) continue;
                this.errorln("Wrong identifier value at index " + i + ": " + value + " : " + PUSH2_ID[i]);
                return;
            }
            this.majorVersion = PushControlSurface.hexByteAt(data, 12);
            this.minorVersion = PushControlSurface.hexByteAt(data, 13);
            this.buildNumber = PushControlSurface.hexByteAt(data, 14) + (PushControlSurface.hexByteAt(data, 15) << 7);
            this.serialNumber = PushControlSurface.hexByteAt(data, 16) + (PushControlSurface.hexByteAt(data, 17) << 7) + (PushControlSurface.hexByteAt(data, 18) << 14) + (PushControlSurface.hexByteAt(data, 19) << 21) + (PushControlSurface.hexByteAt(data, 20) << 28);
            this.boardRevision = byteLength > 21 ? PushControlSurface.hexByteAt(data, 21) : 0;
        } else {
            int byteLength = data.length() / 2;
            if (byteLength < 35) {
                this.errorln("Wrong Push 1 identifier length " + byteLength + " but must be " + 35);
                return;
            }
            for (int i = 0; i < PUSH1_ID.length; ++i) {
                int value = PushControlSurface.hexByteAt(data, i);
                if (value == PUSH1_ID[i]) continue;
                this.errorln("Wrong identifier value at index " + i + ": " + value + " : " + PUSH1_ID[i]);
                return;
            }
            this.majorVersion = PushControlSurface.hexByteAt(data, 10);
            this.minorVersion = PushControlSurface.hexByteAt(data, 12) + PushControlSurface.hexByteAt(data, 11) * 10;
            this.buildNumber = 0;
            this.serialNumber = 0;
            this.boardRevision = 0;
        }
    }

    private static int hexByteAt(String data, int index) {
        int pos = index * 2;
        return Integer.parseInt(data.substring(pos, pos + 2), 16);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public int getBoardRevision() {
        return this.boardRevision;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public boolean shouldUpdateButton(int button) {
        return PUSH_BUTTON_UPDATE[button];
    }

    static {
        Arrays.fill(PUSH_BUTTON_UPDATE, false);
        PushControlSurface.PUSH_BUTTON_UPDATE[3] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[48] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[49] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[52] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[53] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[56] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[59] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[87] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[88] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[116] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[117] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[118] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[119] = true;
        PushControlSurface.PUSH_BUTTON_UPDATE[31] = true;
        PUSH_PAD_CURVES_DATA = new String[]{"00 00 00 01 08 06 0A 00 00 00 00 00 0A 0F 0C 08 00 00 00 00 00 00 00 00", "00 00 00 01 04 0C 00 08 00 00 00 01 0D 04 0C 00 00 00 00 00 0E 0A 06 00", "00 00 00 01 04 0C 00 08 00 00 00 01 0D 04 0C 00 00 00 00 00 0C 03 05 00", "00 00 00 01 08 06 0A 00 00 00 00 01 0D 04 0C 00 00 00 00 00 0C 03 05 00", "00 00 00 01 0F 0B 0D 00 00 00 00 01 0D 04 0C 00 00 00 00 00 0C 03 05 00", "00 00 00 02 02 02 0E 00 00 00 00 01 0D 04 0C 00 00 00 00 00 00 00 00 00"};
        PUSH_PAD_THRESHOLDS_DATA = new String[]{"00 00 00 0A 00 00 00 0A", "00 00 01 03 00 00 01 04", "00 00 01 0C 00 00 01 0E", "00 00 02 05 00 00 02 08", "00 00 02 0E 00 00 03 02", "00 00 03 07 00 00 03 0C", "00 00 04 00 00 00 04 06", "00 00 04 09 00 00 05 00", "00 00 05 02 00 00 05 0A", "00 00 05 0B 00 00 06 04", "00 00 06 04 00 00 06 0E", "00 00 06 0D 00 00 07 08", "00 00 07 06 00 00 08 02", "00 00 07 0F 00 00 08 0C", "00 00 08 08 00 00 09 06", "00 00 09 01 00 00 0A 00", "00 00 09 0A 00 00 0A 0A", "00 00 0A 03 00 00 0B 04", "00 00 0A 0C 00 00 0B 0E", "00 00 0B 05 00 00 0C 08", "00 00 0B 0E 00 00 0D 02", "00 00 0C 07 00 00 0D 0C", "00 00 0D 00 00 00 0E 06", "00 00 0D 08 00 00 0E 0F", "00 00 0E 02 00 00 0F 0A", "00 00 0E 0B 00 01 00 04", "00 00 0F 04 00 01 00 0E", "00 00 0F 0D 00 01 01 08", "00 01 00 06 00 01 02 02", "00 01 00 0F 00 01 02 0C", "00 01 01 08 00 01 03 06", "00 01 02 01 00 01 04 00", "00 01 02 0A 00 01 04 0A", "00 01 03 03 00 01 05 04", "00 01 03 0C 00 01 05 0E", "00 01 04 05 00 01 06 08", "00 01 04 0E 00 01 07 02", "00 01 05 07 00 01 07 0C", "00 01 06 00 00 01 08 06", "00 01 06 09 00 01 09 00", "00 01 07 02 00 01 09 0A"};
        MAXW = new int[]{1700, 1660, 1590, 1510, 1420, 1300, 1170, 1030, 860, 640, 400};
        PUSH2_CPMIN = new int[]{1650, 1580, 1500, 1410, 1320, 1220, 1110, 1000, 900, 800, 700};
        PUSH2_CPMAX = new int[]{2050, 1950, 1850, 1750, 1650, 1570, 1490, 1400, 1320, 1240, 1180};
        GAMMA = new double[]{0.7, 0.64, 0.58, 0.54, 0.5, 0.46, 0.43, 0.4, 0.36, 0.32, 0.25};
        MINV = new int[]{1, 1, 1, 1, 1, 1, 3, 6, 12, 24, 36};
        MAXV = new int[]{96, 102, 116, 121, 124, 127, 127, 127, 127, 127, 127};
        ALPHA = new int[]{90, 70, 54, 40, 28, 20, 10, -5, -25, -55, -90};
    }
}

