/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.controller;

import de.mossgrabers.controller.push.controller.display.model.DisplayModel;
import de.mossgrabers.controller.push.controller.display.model.grid.BoxListGridElement;
import de.mossgrabers.controller.push.controller.display.model.grid.ChannelGridElement;
import de.mossgrabers.controller.push.controller.display.model.grid.ChannelSelectionGridElement;
import de.mossgrabers.controller.push.controller.display.model.grid.GridElement;
import de.mossgrabers.controller.push.controller.display.model.grid.ListGridElement;
import de.mossgrabers.controller.push.controller.display.model.grid.MidiClipElement;
import de.mossgrabers.controller.push.controller.display.model.grid.OptionsGridElement;
import de.mossgrabers.controller.push.controller.display.model.grid.ParamGridElement;
import de.mossgrabers.controller.push.controller.display.model.grid.SendsGridElement;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.List;

public class DisplayMessage {
    public static final int GRID_ELEMENT_CHANNEL_SELECTION = 0;
    public static final int GRID_ELEMENT_CHANNEL_VOLUME = 1;
    public static final int GRID_ELEMENT_CHANNEL_PAN = 2;
    public static final int GRID_ELEMENT_CHANNEL_CROSSFADER = 3;
    public static final int GRID_ELEMENT_CHANNEL_SENDS = 4;
    public static final int GRID_ELEMENT_CHANNEL_ALL = 5;
    public static final int GRID_ELEMENT_PARAMETERS = 6;
    public static final int GRID_ELEMENT_OPTIONS = 7;
    public static final int GRID_ELEMENT_LIST = 8;
    private DisplayModel model;
    private final List<GridElement> elements = new ArrayList<GridElement>(8);

    public DisplayMessage(DisplayModel model) {
        this.model = model;
    }

    public void send() {
        this.model.setGridElements(this.elements);
    }

    public void setMidiClipElement(ICursorClip clip, int quartersPerMeasure) {
        this.elements.clear();
        this.elements.add(new MidiClipElement(clip, quartersPerMeasure));
    }

    public DisplayMessage setMessage(int column, String text) {
        for (int i = 0; i < 8; ++i) {
            this.addOptionElement(column == i ? text : "", "", false, "", "", false, false);
        }
        return this;
    }

    public void addEmptyElement() {
        this.addOptionElement("", "", false, "", "", false, false);
    }

    public void addChannelSelectorElement(String topMenu, boolean isTopMenuOn, String bottomMenu, ChannelType type, double[] bottomMenuColor, boolean isBottomMenuOn) {
        this.elements.add(new ChannelSelectionGridElement(topMenu, isTopMenuOn, bottomMenu, new ColorEx(bottomMenuColor[0], bottomMenuColor[1], bottomMenuColor[2]), isBottomMenuOn, type));
    }

    public void addChannelElement(String topMenu, boolean isTopMenuOn, String bottomMenu, ChannelType type, double[] bottomMenuColor, boolean isBottomMenuOn, int volume, int modulatedVolume, String volumeStr, int pan, int modulatedPan, String panStr, int vu, boolean mute, boolean solo, boolean recarm, int crossfadeMode) {
        this.addChannelElement(5, topMenu, isTopMenuOn, bottomMenu, type, bottomMenuColor, isBottomMenuOn, volume, modulatedVolume, volumeStr, pan, modulatedPan, panStr, vu, mute, solo, recarm, crossfadeMode);
    }

    public void addChannelElement(int channelType, String topMenu, boolean isTopMenuOn, String bottomMenu, ChannelType type, double[] bottomMenuColor, boolean isBottomMenuOn, int volume, int modulatedVolume, String volumeStr, int pan, int modulatedPan, String panStr, int vu, boolean mute, boolean solo, boolean recarm, int crossfadeMode) {
        int editType;
        switch (channelType) {
            case 1: {
                editType = 0;
                break;
            }
            case 2: {
                editType = 1;
                break;
            }
            case 3: {
                editType = 2;
                break;
            }
            default: {
                editType = 3;
            }
        }
        this.elements.add(new ChannelGridElement(editType, topMenu, isTopMenuOn, bottomMenu, new ColorEx(bottomMenuColor[0], bottomMenuColor[1], bottomMenuColor[2]), isBottomMenuOn, type, volume, modulatedVolume, volumeStr, pan, modulatedPan, panStr, vu, mute, solo, recarm, crossfadeMode));
    }

    public void addSendsElement(String topMenu, boolean isTopMenuOn, String bottomMenu, ChannelType type, double[] bottomMenuColor, boolean isBottomMenuOn, String[] sendName, String[] valueStr, int[] value, int[] modulatedValue, boolean[] selected, boolean isTrackMode) {
        this.elements.add(new SendsGridElement(sendName, valueStr, value, modulatedValue, selected, topMenu, isTopMenuOn, bottomMenu, new ColorEx(bottomMenuColor[0], bottomMenuColor[1], bottomMenuColor[2]), isBottomMenuOn, type, isTrackMode));
    }

    public void addParameterElement(String parameterName, int parameterValue, String parameterValueStr, boolean parameterIsActive, int parameterModulatedValue) {
        this.addParameterElement("", false, "", ChannelType.EFFECT, new double[]{0.0, 0.0, 0.0}, false, parameterName, parameterValue, parameterValueStr, parameterIsActive, parameterModulatedValue);
    }

    public void addParameterElement(String topMenu, boolean isTopMenuOn, String bottomMenu, ChannelType type, double[] bottomMenuColor, boolean isBottomMenuOn, String parameterName, int parameterValue, String parameterValueStr, boolean parameterIsActive, int parameterModulatedValue) {
        this.elements.add(new ParamGridElement(topMenu, isTopMenuOn, bottomMenu, type, new ColorEx(bottomMenuColor[0], bottomMenuColor[1], bottomMenuColor[2]), isBottomMenuOn, parameterName, parameterValue, parameterModulatedValue, parameterValueStr, parameterIsActive));
    }

    public void addParameterElement(String topMenu, boolean isTopMenuOn, String bottomMenu, String deviceName, double[] bottomMenuColor, boolean isBottomMenuOn, String parameterName, int parameterValue, String parameterValueStr, boolean parameterIsActive, int parameterModulatedValue) {
        this.elements.add(new ParamGridElement(topMenu, isTopMenuOn, bottomMenu, deviceName, new ColorEx(bottomMenuColor[0], bottomMenuColor[1], bottomMenuColor[2]), isBottomMenuOn, parameterName, parameterValue, parameterModulatedValue, parameterValueStr, parameterIsActive));
    }

    public void addOptionElement(String headerTopName, String menuTopName, boolean isMenuTopSelected, String headerBottomName, String menuBottomName, boolean isMenuBottomSelected, boolean useSmallTopMenu) {
        this.elements.add(new OptionsGridElement(headerTopName, menuTopName, isMenuTopSelected, headerBottomName, menuBottomName, isMenuBottomSelected, useSmallTopMenu));
    }

    public void addListElement(String[] items, boolean[] selected) {
        ArrayList<Pair<String, Boolean>> menu = new ArrayList<Pair<String, Boolean>>();
        for (int i = 0; i < items.length; ++i) {
            menu.add(new Pair<String, Boolean>(items[i], selected[i]));
        }
        this.elements.add(new ListGridElement(menu));
    }

    public void addBoxListElement(String[] items, List<double[]> colors) {
        this.elements.add(new BoxListGridElement(items, colors));
    }
}

