/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;

public class VolumeCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public VolumeCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        Integer currentMode = modeManager.getActiveModeId();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (!config.isPush2() && ((PushControlSurface)this.surface).isSelectPressed() && Modes.isLayerMode(currentMode)) {
            modeManager.setActiveMode(Modes.MODE_DEVICE_LAYER_VOLUME);
            return;
        }
        if (Modes.MODE_VOLUME.equals(currentMode)) {
            if (this.model.getHost().hasCrossfader()) {
                modeManager.setActiveMode(Modes.MODE_CROSSFADER);
            }
        } else {
            modeManager.setActiveMode(Modes.MODE_VOLUME);
        }
    }
}

