/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TrackCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public TrackCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            config.setVUMetersEnabled(!config.isEnableVUMeters());
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        Integer currentMode = modeManager.getActiveModeId();
        if (currentMode != null) {
            if (config.isPush2()) {
                if (Modes.MODE_TRACK.equals(currentMode) || Modes.MODE_VOLUME.equals(currentMode) || Modes.MODE_CROSSFADER.equals(currentMode) || Modes.MODE_PAN.equals(currentMode)) {
                    this.model.toggleCurrentTrackBank();
                } else if (currentMode >= Modes.MODE_SEND1 && currentMode <= Modes.MODE_SEND8) {
                    modeManager.setActiveMode(Modes.MODE_TRACK);
                    this.model.toggleCurrentTrackBank();
                } else {
                    modeManager.setActiveMode(config.getCurrentMixMode());
                }
            } else {
                if (((PushControlSurface)this.surface).isSelectPressed() && Modes.isLayerMode(currentMode)) {
                    modeManager.setActiveMode(Modes.MODE_DEVICE_LAYER);
                    return;
                }
                if (currentMode == Modes.MODE_TRACK) {
                    this.model.toggleCurrentTrackBank();
                } else {
                    modeManager.setActiveMode(Modes.MODE_TRACK);
                }
            }
        } else {
            modeManager.setActiveMode(Modes.MODE_TRACK);
        }
        config.setDebugMode(modeManager.getActiveModeId());
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack track = tb.getSelectedTrack();
        if (track == null) {
            tb.getTrack(0).select();
        }
    }
}

