/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ViewManager;

public class SelectSessionViewCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    private boolean isTemporary;

    public SelectSessionViewCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    public void setTemporary() {
        this.isTemporary = true;
    }

    @Override
    public void execute(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.isTemporary = false;
            ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
            if (Views.isSessionView(viewManager.getActiveViewId())) {
                ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
                if (modeManager.isActiveMode(Modes.MODE_SESSION_VIEW_SELECT)) {
                    modeManager.restoreMode();
                } else {
                    modeManager.setActiveMode(Modes.MODE_SESSION_VIEW_SELECT);
                }
            } else {
                viewManager.setActiveView(Views.VIEW_SESSION);
            }
            return;
        }
        if (event == ButtonEvent.UP && this.isTemporary) {
            ((PushControlSurface)this.surface).getViewManager().restoreView();
        }
    }
}

